/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.stax.api.StaxClient;
import org.apache.commons.cli.Options;

public class ApplicationTail
extends Command {
    private String appid;
    private String logName;

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    @Override
    protected String getUsageMessage() {
        return "[Options] LOGNAME              server, access or error";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("a", "appid", true, "CloudBees application ID");
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        boolean ok = true;
        List otherArgs = this.getCommandLine().getArgList();
        if (otherArgs.size() > 0) {
            this.setLogName((String)otherArgs.get(0));
        }
        return ok;
    }

    @Override
    protected boolean execute() {
        try {
            this.initAppId();
            String defaultAppDomain = this.getConfigProperties().getProperty("bees.project.app.domain");
            String[] appIdParts = this.appid.split("/");
            String domain = null;
            if (appIdParts.length > 1) {
                domain = appIdParts[0];
            } else if (defaultAppDomain != null && !defaultAppDomain.equals("")) {
                domain = defaultAppDomain;
                this.appid = domain + "/" + this.appid;
            } else {
                throw new RuntimeException("default app domain could not be determined, appid needs to be fully-qualified ");
            }
            if (this.logName == null) {
                this.logName = "server";
            }
            StaxClient client = this.getStaxClient();
            client.tailLog(this.appid, this.logName, (OutputStream)System.out);
        }
        catch (Exception e) {
            throw new RuntimeException("Application Info failure: " + e.getMessage(), e);
        }
        return true;
    }

    private void initAppId() throws IOException {
        if (this.appid == null || this.appid.equals("")) {
            this.appid = Helper.promptForAppId();
        }
        if (this.appid == null || this.appid.equals("")) {
            throw new IllegalArgumentException("No application id specified");
        }
    }
}

