/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.utils.Helper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Properties;
import net.stax.api.StaxClient;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public abstract class Command {
    private String[] args;
    private String help;
    private String key;
    private String secret;
    private String server;
    private String apiserver;
    private Properties properties;
    private CommandLineParser parser;
    private Options options;
    private CommandLine line;
    private boolean addCredentialsOptions = true;

    public void init(String commandName, String[] args) {
        this.args = args;
        this.help = commandName + " " + this.getUsageMessage();
        this.properties = Helper.initConfigProperties(false);
        this.parser = new PosixParser();
        this.options = new Options();
        if (this.addCredentialsOptions) {
            this.options.addOption("k", "key", true, "CloudBees API key");
            this.options.addOption("s", "secret", true, "CloudBees API secret");
            this.options.addOption("se", "server", true, "API server");
        }
        if (!this.preParseCommandLine()) {
            this.printHelp(this.help);
            return;
        }
        this.initDefaults(this.getConfigProperties());
        if (!this.parseCommandLine()) {
            this.printHelp(this.help);
            return;
        }
        if (this.isHelp()) {
            this.printHelp(this.help);
        }
    }

    public void run() {
        if (!this.postParseCommandLine()) {
            this.printHelp(this.help);
            return;
        }
        if (!this.execute()) {
            this.printHelp(this.help);
        }
    }

    public void printHelp() {
        this.printHelp(this.help);
    }

    protected abstract boolean preParseCommandLine();

    protected abstract boolean postParseCommandLine();

    protected abstract boolean execute();

    protected abstract String getUsageMessage();

    protected boolean parseCommandLine() {
        boolean ok = true;
        try {
            this.line = this.getParser().parse(this.getOptions(), this.getArgs());
            for (Option option : this.line.getOptions()) {
                Method method;
                Class[] types;
                String str = option.getLongOpt();
                if (option.hasArg()) {
                    types = new Class[]{String.class};
                    method = this.getMethod(str, "", types);
                    if (method == null) {
                        method = this.getMethod(str, "Option", types);
                    }
                    method.invoke((Object)this, option.getValue());
                    continue;
                }
                types = new Class[]{Boolean.class};
                method = this.getMethod(str, "", types);
                if (method == null) {
                    method = this.getMethod(str, "Option", types);
                }
                method.invoke((Object)this, Boolean.TRUE);
            }
        }
        catch (Exception e) {
            System.err.println("Unexpected exception:" + e.getMessage());
            ok = false;
        }
        return ok;
    }

    public boolean hasCredentialsOptions() {
        return this.addCredentialsOptions;
    }

    public void setAddCredentialsOptions(boolean addCredentialsOptions) {
        this.addCredentialsOptions = addCredentialsOptions;
    }

    private Method getMethod(String str, String postFix, Class[] types) {
        try {
            String methodName = "set" + str.substring(0, 1).toUpperCase() + str.substring(1) + postFix;
            Method method = this.getClass().getMethod(methodName, types);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    protected CommandLineParser getParser() {
        return this.parser;
    }

    protected Options getOptions() {
        return this.options;
    }

    protected CommandLine getCommandLine() {
        return this.line;
    }

    public String[] getArgs() {
        return this.args;
    }

    protected String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    protected String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    protected String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    protected String getApiserver() {
        return this.apiserver;
    }

    protected Properties getConfigProperties() {
        return this.properties;
    }

    protected void setApiserver(String apiserver) {
        this.apiserver = apiserver;
    }

    protected void initDefaults(Properties properties) {
        if (this.getApiserver() == null) {
            this.setApiserver("api.cloudbees.com");
        }
        if (this.key == null) {
            this.key = properties.getProperty("bees.api.key");
        }
        if (this.secret == null) {
            this.secret = properties.getProperty("bees.api.secret");
        }
    }

    protected void printHelp(String command) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(command, this.getOptions());
    }

    protected StaxClient getStaxClient() throws IOException {
        this.initCredentials();
        String apiUrl = this.getServer() != null ? String.format("http://%s/api", this.getServer()) : this.properties.getProperty("bees.api.url", String.format("http://%s/api", this.getApiserver()));
        return new StaxClient(apiUrl, this.key, this.secret, "xml", "1.0");
    }

    private boolean isHelp() {
        return this.args != null && this.args.length > 0 && this.args[0].equalsIgnoreCase("help");
    }

    private void initCredentials() throws IOException {
        boolean promptForApiKey = this.key == null;
        boolean promptForApiSecret = this.key == null || this.secret == null;
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
        if (promptForApiKey) {
            System.out.print("Enter your CloudBees API key: ");
            this.key = inputReader.readLine();
        }
        if (promptForApiSecret) {
            System.out.print("Enter your CloudBees Api secret: ");
            this.secret = inputReader.readLine();
        }
    }
}

