/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import java.util.List;
import net.stax.api.DatabaseCreateResponse;
import net.stax.api.StaxClient;
import org.apache.commons.cli.Options;

public class DatabaseCreate
extends Command {
    private String databaseName;
    private String username;
    private String password;
    private String account;

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    @Override
    protected String getUsageMessage() {
        return "[Options] DatabaseName";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("u", "username", true, "Database username (must be unique)");
        options.addOption("p", "password", true, "Database password");
        options.addOption("a", "account", true, "Account Name");
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        boolean ok = false;
        List otherArgs = this.getCommandLine().getArgList();
        if (otherArgs.size() > 0) {
            this.setDatabaseName((String)otherArgs.get(0));
            ok = true;
        }
        return ok;
    }

    @Override
    protected boolean execute() {
        try {
            if (this.databaseName == null) {
                this.databaseName = Helper.promptFor("Database name: ", true);
            }
            if (this.username == null) {
                this.username = Helper.promptFor("Database Username (must be unique): ", true);
            }
            if (this.password == null) {
                this.password = Helper.promptFor("Database Password: ", true);
            }
            if (this.account == null) {
                this.account = this.getConfigProperties().getProperty("bees.project.app.domain");
            }
            if (this.account == null) {
                this.account = Helper.promptFor("Account name: ", true);
            }
            StaxClient client = this.getStaxClient();
            DatabaseCreateResponse res = client.databaseCreate(this.account, this.databaseName, this.username, this.password);
            System.out.println("database created: " + res.getDatabaseId());
        }
        catch (Exception e) {
            throw new RuntimeException("Application Info failure: " + e.getMessage(), e);
        }
        return true;
    }
}

