/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import java.io.IOException;
import java.util.List;
import net.stax.api.DatabaseDeleteResponse;
import net.stax.api.StaxClient;
import org.apache.commons.cli.Options;

public class DatabaseDelete
extends Command {
    private Boolean force;
    private String databaseName;

    public void setForce(Boolean force) {
        this.force = force;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    protected String getUsageMessage() {
        return "[Options] DatabaseName";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("f", "force", false, "print the database password info");
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        boolean ok = false;
        List otherArgs = this.getCommandLine().getArgList();
        if (otherArgs.size() > 0) {
            this.setDatabaseName((String)otherArgs.get(0));
            ok = true;
        }
        return ok;
    }

    @Override
    protected boolean execute() {
        try {
            StaxClient client;
            DatabaseDeleteResponse res;
            this.initDataBaseName();
            if (this.force == null || !this.force.booleanValue()) {
                String in = Helper.promptFor("Are you sure you want to delete this database [" + this.databaseName + "]: (y/n) ");
                if (in != null) {
                    in = in.trim().toLowerCase();
                }
                if (in == null || in.startsWith("n")) {
                    return true;
                }
            }
            if ((res = (client = this.getStaxClient()).databaseDelete(this.databaseName)).isDeleted()) {
                System.out.println("database deleted - " + this.databaseName);
            } else {
                System.out.println("database could not be deleted");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Application Info failure: " + e.getMessage(), e);
        }
        return true;
    }

    private void initDataBaseName() throws IOException {
        if (this.databaseName == null || this.databaseName.equals("")) {
            this.databaseName = Helper.promptFor("Database name: ");
        }
        if (this.databaseName == null || this.databaseName.equals("")) {
            throw new IllegalArgumentException("No database name specified");
        }
    }
}

