/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import java.io.IOException;
import java.util.List;
import net.stax.api.StaxClient;
import org.apache.commons.cli.Options;

public class DatabaseInfo
extends Command {
    private Boolean password;
    private String databaseName;

    public void setPassword(Boolean password) {
        this.password = password;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    protected String getUsageMessage() {
        return "[Options] DatabaseName";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("p", "password", false, "print the database password info");
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        boolean ok = false;
        List otherArgs = this.getCommandLine().getArgList();
        if (otherArgs.size() > 0) {
            this.setDatabaseName((String)otherArgs.get(0));
            ok = true;
        }
        return ok;
    }

    @Override
    protected boolean execute() {
        try {
            this.initDataBaseName();
            StaxClient client = this.getStaxClient();
            boolean fetchPassword = this.password != null;
            net.stax.api.DatabaseInfo res = client.databaseInfo(this.databaseName, fetchPassword);
            System.out.println("Database name: " + res.getName());
            System.out.println("Status:        " + res.getStatus());
            System.out.println("Master:        " + res.getMaster() + ":" + res.getPort());
            System.out.println("Slaves:        " + res.getSlaves());
            System.out.println("JDBC URL:      jdbc:cloudbees://" + res.getName());
            System.out.println("Username:      " + res.getUsername());
            if (fetchPassword) {
                System.out.println("Password:      " + res.getPassword());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Application Info failure: " + e.getMessage(), e);
        }
        return true;
    }

    private void initDataBaseName() throws IOException {
        if (this.databaseName == null || this.databaseName.equals("")) {
            this.databaseName = Helper.promptFor("Database name: ");
        }
        if (this.databaseName == null || this.databaseName.equals("")) {
            throw new IllegalArgumentException("No database name specified");
        }
    }
}

