/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import com.staxnet.repository.LocalRepository;
import java.io.File;
import java.util.List;
import java.util.Properties;
import net.stax.appgen.AppGenerator;
import org.apache.commons.cli.Options;

public class ProjectCreate
extends Command {
    private String appid;
    private String packageOption;
    private String applicationDirectory;
    private String template;
    private Boolean verbose;

    public ProjectCreate() {
        this.setAddCredentialsOptions(false);
    }

    @Override
    protected String getUsageMessage() {
        return "[Options] APP_DIR";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("a", "appid", true, "CloudBees application Id (default is APP_DIR)");
        options.addOption("p", "package", true, "Message describing the deployment");
        options.addOption("v", "verbose", false, "verbose debugging output");
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        boolean ok = false;
        List otherArgs = this.getCommandLine().getArgList();
        if (otherArgs.size() > 0) {
            this.setApplicationDirectory((String)otherArgs.get(0));
            ok = true;
        }
        return ok;
    }

    public String getApplicationDirectory() {
        return this.applicationDirectory;
    }

    public void setApplicationDirectory(String applicationDirectory) {
        this.applicationDirectory = applicationDirectory;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getAppid() {
        return this.appid == null ? this.getApplicationDirectory() : this.appid;
    }

    public void setPackageOption(String packageOption) {
        this.packageOption = packageOption;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose == null ? false : this.verbose;
    }

    public String getTemplate() {
        return this.template == null ? "basic" : this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    protected boolean execute() {
        try {
            String beesTemplates = new File(System.getProperty("user.home"), ".bees/templates").getCanonicalPath();
            if (!new File(beesTemplates).exists()) {
                new File(beesTemplates).mkdirs();
            }
            File templateFile = null;
            String templateId = this.getTemplate();
            if (templateId.indexOf(47) == -1 && templateId.indexOf(92) == -1) {
                System.out.println("loading remote template: " + templateId);
                LocalRepository repo = new LocalRepository();
                templateFile = repo.getApplicationTemplateZip(templateId);
            } else {
                System.out.println("loading local template: " + new File(templateId).getAbsolutePath());
                templateFile = new File(templateId);
            }
            if (templateFile == null || !templateFile.exists()) {
                System.err.println("No such template: " + templateId);
                return false;
            }
            System.out.println("Installing from template:  " + templateFile);
            Properties props = new Properties();
            props.setProperty("appid", this.getAppid());
            if (this.packageOption != null) {
                props.setProperty("package", this.packageOption);
            }
            this.createApplication(templateFile.getAbsolutePath(), new File(this.getApplicationDirectory()).getAbsolutePath(), this.isVerbose(), props);
        }
        catch (Exception e) {
            throw new RuntimeException("Application Deployment failure: " + e.getMessage(), e);
        }
        return true;
    }

    private void createApplication(String templateDir, String outputDir, boolean verbose, Properties props) {
        File appgenPropFile = new File(templateDir, "appgen.properties");
        Helper.loadProperties(appgenPropFile, props);
        AppGenerator appgen = new AppGenerator(new File(templateDir, "appgen.xml"), props);
        appgen.setVerbose(verbose);
        File outputDirFile = new File(outputDir);
        outputDirFile.mkdirs();
        appgen.generate(outputDirFile);
    }
}

