/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.AntTarget;
import org.apache.commons.cli.Options;

public class ProjectDeploy
extends AntTarget {
    private String message;
    private String environment;
    private String appid;
    private String delta;

    public ProjectDeploy() {
        super("deploy");
        this.setAddCredentialsOptions(true);
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getAppid() {
        return this.appid == null ? "" : this.appid;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getMessage() {
        return this.message == null ? "" : this.message;
    }

    public String getEnvironment() {
        return this.environment == null ? "" : this.environment;
    }

    public String getDelta() {
        return this.delta == null ? "true" : this.delta;
    }

    public void setDelta(String delta) {
        this.delta = delta;
    }

    @Override
    protected String getUsageMessage() {
        return "[options]";
    }

    @Override
    protected boolean preParseCommandLine() {
        Options options = this.getOptions();
        options.addOption("a", "appid", true, "CloudBees application ID");
        options.addOption("m", "message", true, "Message describing the deployment");
        options.addOption("e", "environment", true, "Environment configurations to deploy");
        options.addOption("d", "delta", true, "true to enable, false to disable delta upload (default: true)");
        return super.preParseCommandLine();
    }

    @Override
    protected boolean postParseCommandLine() {
        this.addAntProperty("stax.appid", this.getAppid());
        this.addAntProperty("stax.message", this.getMessage());
        this.addAntProperty("stax.environment", this.getEnvironment());
        this.addAntProperty("bees.appid", this.getAppid());
        this.addAntProperty("bees.message", this.getMessage());
        this.addAntProperty("bees.environment", this.getEnvironment());
        this.addAntProperty("bees.delta", this.getDelta());
        this.addAntProperty("stax.username", this.getKey() == null ? "" : this.getKey());
        this.addAntProperty("stax.password", this.getSecret() == null ? "" : this.getSecret());
        return super.postParseCommandLine();
    }
}

