/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.commands;

import com.cloudbees.sdk.commands.Command;
import com.cloudbees.sdk.utils.Helper;
import java.io.File;
import java.io.IOException;

public class Reset
extends Command {
    public Reset() {
        this.setAddCredentialsOptions(false);
    }

    @Override
    protected String getUsageMessage() {
        return ">> Reset all configuration parameters";
    }

    @Override
    protected boolean preParseCommandLine() {
        return true;
    }

    @Override
    protected boolean postParseCommandLine() {
        return true;
    }

    @Override
    protected boolean execute() {
        try {
            String input = Helper.promptFor("Are you sure you want to delete your [user.home].bees configuration directory? (y/n) ", true);
            input = input.toLowerCase().trim();
            if (input.startsWith("y")) {
                Helper.deleteDirectory(new File(System.getProperty("user.home"), ".bees"));
                Helper.initConfigProperties(true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Reset failure: " + e.getMessage(), e);
        }
        return true;
    }
}

