/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.utils;

import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.AppConfigHelper;
import com.staxnet.appserver.utils.ZipHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.zip.ZipEntry;

public class Helper {
    public static String promptForAppId() throws IOException {
        return Helper.promptFor("Enter application ID (ex: account/appname) : ");
    }

    public static String promptFor(String message, boolean cannotBeNull) throws IOException {
        String input = Helper.promptFor(message);
        if (cannotBeNull && (input == null || input.trim().length() == 0)) {
            return Helper.promptFor(message, cannotBeNull);
        }
        return input;
    }

    public static String promptFor(String message) throws IOException {
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(message);
        String input = inputReader.readLine();
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppConfig getAppConfig(File deployZip, final String[] environments, final String[] implicitEnvironments) throws IOException {
        final AppConfig appConfig = new AppConfig();
        FileInputStream fin = new FileInputStream(deployZip);
        try {
            ZipHelper.unzipFile((InputStream)fin, (ZipHelper.ZipEntryHandler)new ZipHelper.ZipEntryHandler(){

                public void unzip(ZipEntry entry, InputStream zis) throws IOException {
                    if (entry.getName().equals("META-INF/stax-application.xml") || entry.getName().equals("WEB-INF/stax-web.xml") || entry.getName().equals("WEB-INF/cloudbees-web.xml")) {
                        AppConfigHelper.load((AppConfig)appConfig, (InputStream)zis, null, (String[])environments, (String[])implicitEnvironments);
                    }
                }
            }, (boolean)false);
        }
        finally {
            fin.close();
        }
        return appConfig;
    }

    public static Properties initConfigProperties(boolean force) {
        Properties properties = new Properties();
        File userConfigFile = new File(System.getProperty("user.home"), ".bees/bees.config");
        if (force || !Helper.loadProperties(userConfigFile, properties)) {
            System.out.println("You have not created a CloudBees configuration profile yet, let's create one now...");
            System.out.println("Go to https://grandcentral.cloudbees.com/user/keys to retrieve your API key");
            try {
                properties.setProperty("bees.api.url", "https://api.cloudbees.com/api");
                properties.setProperty("bees.api.key", Helper.promptFor("Enter your CloudBees API key: ", true));
                properties.setProperty("bees.api.secret", Helper.promptFor("Enter your CloudBees secret: ", true));
                properties.setProperty("bees.project.app.domain", Helper.promptFor("Enter your default CloudBees account name: ", true));
                if (!userConfigFile.getParentFile().exists()) {
                    userConfigFile.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(userConfigFile);
                properties.store(fos, "CloudBees SDK config");
                fos.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadProperties(File propertyFile, Properties properties) {
        if (propertyFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propertyFile);
                properties.load(fis);
                fis.close();
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    public static void deleteDirectory(File dir) {
        if (dir.exists()) {
            File[] files;
            if (dir.isDirectory() && (files = dir.listFiles()) != null) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        Helper.deleteDirectory(f);
                        continue;
                    }
                    f.delete();
                }
            }
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        byte[] buf = new byte[1024];
        FileInputStream in = new FileInputStream(from);
        try {
            FileOutputStream out = new FileOutputStream(to);
            try {
                int numRead = in.read(buf);
                while (numRead != -1) {
                    out.write(buf, 0, numRead);
                    numRead = in.read(buf);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }
}

