/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.ant;

import com.staxnet.ant.ApplicationHelper;
import com.staxnet.ant.HashWriteProgress;
import com.staxnet.ant.StringHelper;
import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.AppConfigHelper;
import com.staxnet.appserver.utils.ZipHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import net.stax.api.StaxClient;
import net.stax.api.UploadProgress;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DeployTask
extends Task {
    private File deployFile;
    private File srcFile;
    private String message;
    private String username;
    private String password;
    private String apiKey;
    private String apiSecret;
    private String environment;
    private String appId;
    private String delta;

    public void execute() throws BuildException {
        this.deployFile = this.getAttributeFile("deployfile", this.deployFile, true);
        if (this.srcFile != null && this.srcFile.length() > 0L) {
            this.srcFile = this.getAttributeFile("srcfile", this.srcFile, false);
        }
        this.appId = this.getAttributeValue("appid", this.emptyValueToNull(this.appId), false);
        this.message = this.getAttributeValue("message", this.emptyValueToNull(this.message), false);
        this.username = this.emptyValueToNull(this.getAttributeValue("username", this.username, false));
        this.password = this.emptyValueToNull(this.getAttributeValue("password", this.password, false));
        if (this.password != null && !this.password.equals("") || this.username == null || !this.username.equals("")) {
            // empty if block
        }
        this.apiKey = this.getAttributeValue("apiKey", this.getProject().getProperty("beesConfig.bees.api.key"), false);
        this.apiSecret = this.getAttributeValue("apiSecret", this.getProject().getProperty("beesConfig.bees.api.secret"), false);
        String apiVersion = "1.0";
        if (this.apiKey == null) {
            if (this.username == null) {
                this.username = this.getProject().getProperty("beesConfig.bees.api.username");
            }
            if (this.password == null) {
                this.password = this.getProject().getProperty("beesConfig.bees.api.password");
            }
            if (this.username != null) {
                this.apiKey = this.username;
                this.apiSecret = this.password;
                apiVersion = "0.1";
            }
        }
        if (this.apiKey == null || this.apiKey.equals("") || this.apiSecret == null || this.apiSecret.equals("")) {
            throw new BuildException("CloudBees credentials not provided");
        }
        String defaultAppDomain = this.getProject().getProperty("beesConfig.bees.project.app.domain");
        System.out.println("defaultAppDomain=" + defaultAppDomain);
        if (defaultAppDomain == null || defaultAppDomain.equals("")) {
            defaultAppDomain = this.username;
        }
        this.environment = this.emptyValueToNull(this.getAttributeValue("environment", this.emptyValueToNull(this.environment), false));
        String[] appIdParts = this.appId != null ? this.appId.split("@") : new String[]{};
        String appId = appIdParts.length > 0 ? appIdParts[0] : null;
        String server = appIdParts.length == 2 ? appIdParts[1] : null;
        int mbFileSize = (int)((float)this.deployFile.length() / 1024.0f / 1024.0f);
        if (this.srcFile != null) {
            mbFileSize = (int)((float)this.srcFile.length() / 1024.0f / 1024.0f);
        }
        if (mbFileSize > 1) {
            System.out.println(String.format("application package size: %dMB", mbFileSize));
        }
        try {
            String deployFilePath = this.deployFile.getAbsolutePath();
            String srcFilePath = this.srcFile != null ? this.srcFile.getAbsolutePath() : null;
            String apiUrl = this.getProject().getProperty("beesConfig.bees.api.url");
            if (apiUrl == null) {
                apiUrl = "https://api.cloudbees.com/api";
            }
            if (server != null) {
                apiUrl = String.format("https://%s/api", server);
            }
            System.out.println("uploading application to: " + apiUrl);
            StaxClient client = new StaxClient(apiUrl, this.apiKey, this.apiSecret, "xml", apiVersion);
            AppConfig appConfig = this.getAppConfig(this.deployFile, ApplicationHelper.getEnvironmentList(this.environment, new String[0]), new String[]{"deploy"});
            if ((appId == null || appId.equals("")) && ((appId = appConfig.getApplicationId()) == null || appId.equals(""))) {
                throw new IllegalArgumentException("No application id specified");
            }
            appIdParts = appId.split("/");
            String domain = null;
            if (appIdParts.length > 1) {
                domain = appIdParts[0];
            } else if (defaultAppDomain != null && !defaultAppDomain.equals("")) {
                domain = defaultAppDomain;
                appId = domain + "/" + appId;
            } else {
                throw new BuildException("default app domain could not be determined, appid needs to be fully-qualified ");
            }
            this.environment = StringHelper.join(appConfig.getAppliedEnvironments().toArray(new String[0]), ",");
            this.log(String.format("Deploying application: %s (environment: %s)", appId, this.environment));
            String archiveType = deployFilePath.endsWith(".war") ? "war" : "ear";
            this.delta = this.getAttributeValue("delta", this.emptyValueToNull(this.delta), false);
            boolean deployDelta = (this.delta == null || this.delta.equalsIgnoreCase("true")) && archiveType.equals("war");
            System.out.println("Delta upload: " + deployDelta);
            client.applicationDeployArchive(appId, this.environment, this.message, deployFilePath, srcFilePath, archiveType, deployDelta, (UploadProgress)new HashWriteProgress());
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String getAttributeValue(String attrName, String value, boolean required) {
        if (value == null) {
            value = System.getProperty("bees." + attrName);
            if (value == null) {
                value = System.getProperty("stax." + attrName);
            }
            if (value == null) {
                value = this.getProject().getProperty("bees." + attrName);
            }
            if (value == null) {
                value = this.getProject().getProperty("stax." + attrName);
            }
            if (required && (value == null || value.equals(""))) {
                throw new BuildException("missing required attribute: " + attrName);
            }
        }
        return value;
    }

    private File getAttributeFile(String attrName, File value, boolean required) {
        if (value == null) {
            String strValue = System.getProperty("bees." + attrName);
            if (strValue == null) {
                strValue = System.getProperty("stax." + attrName);
            }
            if (strValue == null) {
                if (required) {
                    throw new BuildException("missing required attribute: " + attrName);
                }
            } else {
                value = new File(strValue);
            }
        }
        return value;
    }

    public void setDeployfile(File deployFile) {
        this.deployFile = deployFile;
    }

    public void setSrcfile(File srcFile) {
        this.srcFile = srcFile;
    }

    public void setAppid(String appId) {
        this.appId = appId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public void setEnvironments(String environments) {
        this.environment = environments;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDelta(String delta) {
        this.delta = delta;
    }

    private String emptyValueToNull(String value) {
        if (value != null && !value.equals("")) {
            return value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppConfig getAppConfig(File deployZip, final String[] environments, final String[] implicitEnvironments) throws IOException {
        final AppConfig appConfig = new AppConfig();
        FileInputStream fin = new FileInputStream(deployZip);
        try {
            ZipHelper.unzipFile((InputStream)fin, (ZipHelper.ZipEntryHandler)new ZipHelper.ZipEntryHandler(){

                public void unzip(ZipEntry entry, InputStream zis) throws IOException {
                    if (entry.getName().equals("META-INF/stax-application.xml") || entry.getName().equals("WEB-INF/stax-web.xml") || entry.getName().equals("WEB-INF/cloudbees-web.xml")) {
                        AppConfigHelper.load((AppConfig)appConfig, (InputStream)zis, null, (String[])environments, (String[])implicitEnvironments);
                    }
                }
            }, (boolean)false);
        }
        finally {
            fin.close();
        }
        return appConfig;
    }

    private String prompt(String message) {
        System.out.print(message);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }
}

