/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.ant;

import com.staxnet.ant.ApplicationHelper;
import com.staxnet.ant.StringHelper;
import com.staxnet.appserver.SnazAppServer;
import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.AppConfigHelper;
import java.io.File;
import javax.servlet.ServletException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RunTask
extends Task {
    private File baseDir;
    private File workingDir;
    private File webappDir;
    private int port = 8080;
    private String contextPath = "";
    private File serverXmlFile;
    private File staxappxmlFile;
    private File appxmlFile;
    private String environment;

    public void execute() throws BuildException {
        try {
            if (this.baseDir == null) {
                this.baseDir = this.getProject().getBaseDir();
            }
            this.checkRequiredAttribute("workingdir", this.workingDir);
            this.run(this.workingDir, this.contextPath, this.port, this.staxappxmlFile, this.appxmlFile, this.getEnvironments());
        }
        catch (IllegalArgumentException e) {
            throw new BuildException(e.getMessage());
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void run(File configurationDir, String contextPath, int port, File staxappxml, File appxml, String[] environments) throws ServletException {
        this.log("application environment: " + StringHelper.join(environments, ","));
        SnazAppServer appServer = new SnazAppServer(this.baseDir.getAbsolutePath(), configurationDir.getAbsolutePath(), ((Object)((Object)this)).getClass().getClassLoader(), new String[0], this.serverXmlFile, port, staxappxml, appxml, environments, null);
        appServer.start();
    }

    private void checkRequiredAttribute(String attrName, Object value) {
        if (value == null) {
            throw new BuildException("missing required attribute: " + attrName);
        }
    }

    private String getAttributeValue(String attrName, String value, boolean required) {
        if (value == null) {
            value = System.getProperty("bees." + attrName);
            if (value == null) {
                value = System.getProperty("stax." + attrName);
            }
            if (required && value == null) {
                throw new BuildException("missing required attribute: " + attrName);
            }
        }
        return value;
    }

    public void setContextpath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setWorkingdir(File workingDir) {
        this.workingDir = workingDir;
    }

    public void setWebappdir(File webappDir) {
        this.webappDir = webappDir;
    }

    public void setBaseDir(File webappDir) {
        this.webappDir = webappDir;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAppconfig(File appConfigFile) {
        this.staxappxmlFile = appConfigFile;
    }

    public void setAppxml(File appxmlFile) {
        this.appxmlFile = appxmlFile;
    }

    public void setServerconfig(File serverXmlFile) {
        this.serverXmlFile = serverXmlFile;
    }

    public void setEnvironment(String environments) {
        this.environment = environments;
    }

    private String[] getEnvironments() {
        String envString;
        String string = envString = this.environment != null ? this.environment : this.getProject().getProperty("run.environment");
        if (envString == null || envString.equals("") && this.staxappxmlFile != null && this.staxappxmlFile.exists()) {
            AppConfig appConfig = new AppConfig();
            AppConfigHelper.load((AppConfig)appConfig, (String)this.staxappxmlFile.getAbsolutePath(), (String[])new String[0], (String[])new String[0]);
            envString = appConfig.getDefaultEnvironment();
        }
        String[] environment = ApplicationHelper.getEnvironmentList(envString, "run");
        return environment;
    }
}

