/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.boot;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;

public class Launcher {
    public static final String BEES_CLASS = "com.cloudbees.sdk.Bees";

    public static void main(String[] args) {
        try {
            URL[] urls = Launcher.getJarUrls();
            ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader loader = parentLoader != null ? new URLClassLoader(urls, parentLoader) : new URLClassLoader(urls);
            Class<?> beesClass = loader.loadClass(BEES_CLASS);
            Method mainMethod = beesClass.getDeclaredMethod("main", String[].class);
            Object obj = mainMethod.invoke(null, new Object[]{args});
            int returnValue = 0;
            if (obj instanceof Integer) {
                returnValue = (Integer)obj;
            }
            System.exit(returnValue);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static URL[] getJarUrls() throws MalformedURLException {
        String[] paths;
        String javaHome;
        String resourcePath = Launcher.class.getName().replace(".", "/") + ".class";
        URL baseUrl = Launcher.class.getClassLoader().getResource(resourcePath);
        if (baseUrl == null) {
            throw new IllegalStateException(Launcher.class.getName());
        }
        String filePart = baseUrl.getFile();
        String[] parts = filePart.split("!");
        String fileUrl = parts[0];
        String filePath = new URL(fileUrl).getFile();
        File parentFile = new File(URLDecoder.decode(filePath)).getParentFile();
        ArrayList<URL> list = new ArrayList<URL>();
        String userHome = System.getProperty("user.home");
        Launcher.addJars(new File(userHome, ".bees/lib"), list);
        if (parentFile.isDirectory()) {
            Launcher.addJars(parentFile, list);
        }
        if ((javaHome = System.getenv("JAVA_HOME")) == null && (paths = System.getProperty("sun.boot.library.path").split(",")) != null && paths.length > 0) {
            javaHome = paths[0].trim();
        }
        if (javaHome != null) {
            File javaHomeDir = new File(javaHome);
            File tools = Launcher.findToolsJar(javaHomeDir);
            if (tools != null && tools.exists()) {
                list.add(tools.toURI().toURL());
            } else {
                System.err.println("WARNING: Cannot find JAVA_HOME. Some commands might not work properly");
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    private static void addJars(File dir, ArrayList<URL> list) throws MalformedURLException {
        String[] files = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files != null) {
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                URL u = new File(dir, files[i]).toURI().toURL();
                list.add(u);
            }
        }
    }

    private static File findToolsJar(File dir) {
        if (dir == null) {
            return null;
        }
        File tools = new File(dir, "/lib/tools.jar");
        if (tools.exists()) {
            return tools;
        }
        return Launcher.findToolsJar(dir.getParentFile());
    }
}

