/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver;

import com.staxnet.appserver.EarBasedServerConfiguration;
import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.config.WebConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class ApplicationInstaller {
    protected static Logger logger = Logger.getLogger("appserver");
    private static int BUFFER = 2048;

    ApplicationInstaller() {
    }

    static IAppServerConfiguration getInstalledConfiguration(File installDir, File serverConfig, String[] environments) {
        File staxappxml;
        File appxml = new File(installDir, "META-INF/application.xml");
        if (!appxml.exists()) {
            appxml = null;
        }
        if (!(staxappxml = new File(installDir, "META-INF/stax-application.xml")).exists()) {
            staxappxml = null;
        }
        IAppServerConfiguration appserverConfig = EarBasedServerConfiguration.load(serverConfig, staxappxml, appxml, environments);
        return appserverConfig;
    }

    static IAppServerConfiguration installApplicationZipFile(String zipFilePath, final File installDir, File serverConfig, String[] environments) throws IOException {
        ConfigFileZipEntryHandler configFileExtractor = new ConfigFileZipEntryHandler(installDir);
        ApplicationInstaller.unzipFile(zipFilePath, configFileExtractor);
        IAppServerConfiguration appserverConfig = EarBasedServerConfiguration.load(serverConfig, configFileExtractor.smazAppxmlFile, configFileExtractor.appxmlFile, environments);
        ApplicationInstaller.sterilizeAppServerConfiguration(appserverConfig);
        final HashMap<String, File> warFiles = new HashMap<String, File>();
        for (WebConfig wc : appserverConfig.getAppConfiguration().getWebConfigs()) {
            warFiles.put(wc.getWebUri(), new File(installDir, wc.getWebUri()));
        }
        ApplicationInstaller.unzipFile(zipFilePath, new ZipEntryHandler(){

            @Override
            public void unzip(ZipEntry entry, ZipInputStream zis) throws IOException {
                File destFolder = (File)warFiles.get(entry.getName());
                if (destFolder == null || entry.isDirectory()) {
                    ApplicationInstaller.unzipEntryToFolder(entry, zis, installDir);
                } else {
                    final File dest = destFolder;
                    if (dest != null) {
                        dest.mkdirs();
                        ApplicationInstaller.unzipFile(zis, new ZipEntryHandler(){

                            @Override
                            public void unzip(ZipEntry entry, ZipInputStream zis) throws IOException {
                                ApplicationInstaller.unzipEntryToFolder(entry, zis, dest);
                            }
                        }, false);
                    }
                }
            }
        });
        return appserverConfig;
    }

    private static void sterilizeAppServerConfiguration(IAppServerConfiguration appserverConfig) {
        WebConfig[] configs = appserverConfig.getAppConfiguration().getWebConfigs().toArray(new WebConfig[0]);
        HashMap<String, WebConfig> configTable = new HashMap<String, WebConfig>();
        for (WebConfig wc : configs) {
            boolean validConfig = true;
            String contextPath = wc.getContextRoot();
            String webUri = wc.getWebUri();
            if (contextPath == null) {
                logger.warning("Web module is missing context-root");
                validConfig = false;
            }
            if (validConfig && webUri == null) {
                logger.warning("No web-uri set for web module context-root [" + contextPath + "]");
                validConfig = false;
            }
            if (configTable.containsKey(contextPath)) {
                logger.warning("Duplicate web module context-root detected [" + contextPath + "] web-uri" + webUri + " will not be used");
                validConfig = false;
            }
            if (validConfig) {
                configTable.put(contextPath, wc);
                continue;
            }
            appserverConfig.getAppConfiguration().getWebConfigs().remove(wc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipFile(String file, ZipEntryHandler zipHandler) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            ApplicationInstaller.unzipFile(fis, zipHandler, true);
        }
        finally {
            ((InputStream)fis).close();
        }
    }

    private static void unzipFile(InputStream fis, ZipEntryHandler zipHandler, boolean close) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        while ((entry = zis.getNextEntry()) != null) {
            zipHandler.unzip(entry, zis);
        }
        if (close) {
            zis.close();
        }
    }

    private static File unzipEntryToFolder(ZipEntry entry, ZipInputStream zis, File destFolder) throws FileNotFoundException, IOException {
        int count;
        if (entry.isDirectory()) {
            File destFile = new File(destFolder, entry.getName());
            destFile.mkdirs();
            return destFile;
        }
        byte[] data = new byte[BUFFER];
        File destFile = new File(destFolder, entry.getName());
        File parentFolder = destFile.getParentFile();
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
        while ((count = zis.read(data, 0, BUFFER)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
        return destFile;
    }

    static class ConfigFileZipEntryHandler
    implements ZipEntryHandler {
        public File appxmlFile;
        public File smazAppxmlFile;
        private File destFolder;

        ConfigFileZipEntryHandler(File destFolder) {
            this.destFolder = destFolder;
        }

        @Override
        public void unzip(ZipEntry entry, ZipInputStream zis) throws IOException {
            if (entry.getName().equals("META-INF/application.xml")) {
                this.appxmlFile = ApplicationInstaller.unzipEntryToFolder(entry, zis, this.destFolder);
            } else if (entry.getName().equals("META-INF/stax-application.xml")) {
                this.smazAppxmlFile = ApplicationInstaller.unzipEntryToFolder(entry, zis, this.destFolder);
            }
        }
    }

    static interface ZipEntryHandler {
        public void unzip(ZipEntry var1, ZipInputStream var2) throws IOException;
    }
}

