/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver;

import com.staxnet.appserver.IAppConfiguration;
import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.AppConfigHelper;
import com.staxnet.appserver.config.AppConfigParser;
import com.staxnet.appserver.config.AppServerConfig;
import com.staxnet.appserver.config.DependencyConfig;
import com.staxnet.appserver.config.HttpConfig;
import com.staxnet.appserver.config.RealmConfig;
import com.staxnet.appserver.config.ResourceConfig;
import com.staxnet.appserver.config.ServerParams;
import com.staxnet.appserver.config.SessionConfig;
import com.staxnet.appserver.config.WebConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EarBasedServerConfiguration
implements IAppServerConfiguration,
IAppConfiguration {
    private AppServerConfig appServerConfig;
    private AppConfig appConfig;
    protected static Logger logger = Logger.getLogger(EarBasedServerConfiguration.class.getName());

    private EarBasedServerConfiguration() {
    }

    public static IAppServerConfiguration load(File serverXmlFile, File staxAppXmlFile, File j2eeAppXmlFile, String[] environments) {
        EarBasedServerConfiguration appserverConfig;
        EarBasedServerConfiguration earBasedServerConfiguration = appserverConfig = new EarBasedServerConfiguration();
        earBasedServerConfiguration.getClass();
        AppServerConfigurationLoader loader = earBasedServerConfiguration.new AppServerConfigurationLoader(appserverConfig);
        if (j2eeAppXmlFile == null || !j2eeAppXmlFile.exists()) {
            loader.loadV1(serverXmlFile, staxAppXmlFile, environments);
        } else {
            loader.loadV2(serverXmlFile, staxAppXmlFile, j2eeAppXmlFile, environments);
        }
        return appserverConfig;
    }

    @Override
    public IAppConfiguration getAppConfiguration() {
        return this;
    }

    @Override
    public RealmConfig getRealm() {
        return this.appConfig.getRealm();
    }

    @Override
    public List<ResourceConfig> getResources() {
        return this.appConfig.getResources();
    }

    @Override
    public List<WebConfig> getWebConfigs() {
        return this.appConfig.getWebConfigs();
    }

    @Override
    public String getApplicationId() {
        return this.appConfig.getApplicationId();
    }

    @Override
    public String getSessionDataSource() {
        return this.appConfig.getSessionDataSource();
    }

    @Override
    public SessionConfig getSessionPersistence() {
        return this.appServerConfig.getSessionPersistence();
    }

    @Override
    public String getServerCallbackAuthToken() {
        return this.appServerConfig.getServerCallbackAuthToken();
    }

    @Override
    public String getServerCallbackUrl() {
        return this.appServerConfig.getServerCallbackUrl();
    }

    @Override
    public List<DependencyConfig> getDependencies() {
        return this.appConfig.getDependencies();
    }

    @Override
    public String getDriverCallbackBaseUrl() {
        return this.appServerConfig.getDriverCallbackBaseUrl();
    }

    @Override
    public int getStatusInterval() {
        return this.appServerConfig.getStatusInterval();
    }

    @Override
    public String getColdFusionLicense() {
        return this.appServerConfig.getColdFusionLicense();
    }

    @Override
    public ServerParams getServerParams() {
        return this.appServerConfig.getServerParams();
    }

    @Override
    public boolean isAdminEngineEnabled() {
        return this.appServerConfig.isAdminEngineEnabled();
    }

    @Override
    public boolean isReloadEnabled() {
        return this.appServerConfig.isReloadEnabled();
    }

    @Override
    public HttpConfig getHttpConfig() {
        return this.appServerConfig.getHttpConfig();
    }

    @Override
    public boolean isPrivate() {
        return "private".equals(this.appServerConfig.getSecurityMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAppServerConfig(File configFile) {
        this.appServerConfig = new AppServerConfig();
        InputStream input = null;
        if (configFile != null && configFile.exists()) {
            try {
                logger.info("loading app config: " + configFile.getAbsolutePath());
                File xmlFile = configFile;
                input = new FileInputStream(xmlFile);
            }
            catch (FileNotFoundException e1) {
                // empty catch block
            }
        }
        if (input == null) {
            if (configFile != null && !configFile.exists()) {
                logger.log(Level.WARNING, "server config file does not exist: " + configFile.getAbsolutePath());
            }
            input = this.getClass().getResourceAsStream("/conf/appserver.xml");
        }
        try {
            this.appServerConfig = AppServerConfig.load(input);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error closing config file", e);
            }
        }
    }

    private class AppServerConfigurationLoader {
        private EarBasedServerConfiguration appserverConfig;

        public AppServerConfigurationLoader(EarBasedServerConfiguration appserverConfig) {
            this.appserverConfig = appserverConfig;
        }

        public void loadV1(File serverXmlFile, File staxAppXmlFile, String[] environments) {
            this.loadV2(serverXmlFile, staxAppXmlFile, null, environments);
            for (int i = 0; i < environments.length; ++i) {
                WebConfig config;
                if (!environments[i].equals("run") || (config = this.appserverConfig.appConfig.getWebConfigs().get(0)).getWebUri() != null) continue;
                config.setWebUri("/webapp");
            }
        }

        public void loadV2(File serverXmlFile, File staxAppXmlFile, File j2eeAppXmlFile, String[] environments) {
            this.appserverConfig.appConfig = new AppConfig();
            if (j2eeAppXmlFile != null && j2eeAppXmlFile.exists()) {
                new AppConfigParser().loadFromApplicationXml(this.appserverConfig.appConfig, j2eeAppXmlFile.getAbsolutePath());
            }
            if (staxAppXmlFile != null && staxAppXmlFile.exists()) {
                AppConfigHelper.load(this.appserverConfig.appConfig, staxAppXmlFile.getAbsolutePath(), environments, new String[0]);
            }
            this.appserverConfig.readAppServerConfig(serverXmlFile);
        }
    }
}

