/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;

public class ServerCallbackClient {
    private String authToken;
    private String baseUrl;

    public ServerCallbackClient(String baseUrl, String authToken) {
        this.authToken = authToken;
        this.baseUrl = baseUrl;
    }

    public void updateStatus(State state) throws ServletException, IOException {
        this.invoke("updateStatus", new HashMap<String, String>(), state.toString());
    }

    public AuthenticationResult renewApplicationTicket(String userAuthTicket) throws IOException {
        AuthenticationResult result = (AuthenticationResult)this.invokeWithResult("renewApplicationTicket", new HashMap<String, String>(), userAuthTicket);
        return result;
    }

    public AuthenticationResult getApplicationTicket(String username, String password) throws IOException {
        AuthenticationResult result = (AuthenticationResult)this.invokeWithResult("getApplicationTicket", new HashMap<String, String>(), username, password);
        return result;
    }

    private void invoke(String method, Map<String, String> params, String ... args) throws IOException {
        String urlStr = this.createCallbackURL(method, args);
        URL callbackURL = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)callbackURL.openConnection();
        this.prepareParameters(params, connection);
        connection.connect();
        InputStream input = connection.getInputStream();
        input.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeWithResult(String method, Map<String, String> params, String ... args) throws IOException {
        String urlStr = this.createCallbackURL(method, args);
        URL callbackURL = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)callbackURL.openConnection();
        this.prepareParameters(params, connection);
        connection.connect();
        InputStream input = connection.getInputStream();
        try {
            Object object = this.readResult(input);
            return object;
        }
        finally {
            input.close();
        }
    }

    private void prepareParameters(Map<String, String> params, HttpURLConnection connection) throws ProtocolException, IOException {
        if (params != null && params.size() > 0) {
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            StringBuffer postparameter = new StringBuffer();
            for (String paramName : params.keySet()) {
                String paramValue = params.get(paramName);
                postparameter.append(paramName + "=" + URLEncoder.encode(paramValue));
            }
            OutputStreamWriter outStream = new OutputStreamWriter(connection.getOutputStream());
            outStream.write(postparameter.toString());
            outStream.close();
        }
    }

    Object readResult(InputStream input) {
        XStream xstream = new XStream();
        xstream.processAnnotations(AuthenticationResult.class);
        return xstream.fromXML(input);
    }

    private String createCallbackURL(String method, String[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseUrl);
        sb.append("/");
        sb.append(method);
        sb.append("/");
        sb.append(this.authToken);
        for (String arg : args) {
            sb.append("/");
            sb.append(arg);
        }
        String callbackURL = sb.toString();
        return callbackURL;
    }

    @XStreamAlias(value="authenticationResult")
    public static class AuthenticationResult {
        private ErrorCode errorCode;
        private String authTicket;
        private String username;
        private String role;
        private long authTimeout;

        public AuthenticationResult(ErrorCode code) {
            this.errorCode = code;
        }

        public AuthenticationResult(String authToken, String username, String role, long authTimeout) {
            this.authTicket = authToken;
            this.username = username;
            this.role = role;
            this.authTimeout = authTimeout;
        }

        public String getAuthTicket() {
            return this.authTicket;
        }

        public void setAuthTicket(String authTicket) {
            this.authTicket = authTicket;
        }

        public long getAuthTimeout() {
            return this.authTimeout;
        }

        public void setAuthTimeout(long authTimeout) {
            this.authTimeout = authTimeout;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        static enum ErrorCode {
            Success,
            Error,
            AuthenticationFailed,
            NotAuthorized;

        }
    }

    public static enum State {
        IDLE,
        ACTIVE;

    }
}

