/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver;

import com.staxnet.appserver.ApplicationInstaller;
import com.staxnet.appserver.EarBasedServerConfiguration;
import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.SnazAppServerCLI;
import com.staxnet.appserver.StaxAppServerBase;
import com.staxnet.appserver.config.DependencyConfig;
import com.staxnet.appserver.config.WebConfig;
import com.staxnet.repository.LocalRepository;
import java.io.File;
import java.util.List;
import org.apache.commons.cli.ParseException;

public class SnazAppServer
extends StaxAppServerBase {
    public SnazAppServer(String baseDir, String workingDir, ClassLoader classloader, String[] classpath, File serverXml, int port, File staxAppXml, File appXML, String[] environments, String localRepositoryPath) {
        super(baseDir, workingDir, classloader, classpath, port, EarBasedServerConfiguration.load(serverXml, staxAppXml, appXML, environments), localRepositoryPath);
    }

    public SnazAppServer(String baseDir, String workingDir, ClassLoader classloader, String[] classpath, int port, IAppServerConfiguration config, String localRepositoryPath) {
        super(baseDir, workingDir, classloader, classpath, port, config, localRepositoryPath);
    }

    public static void main(String[] args) {
        SnazAppServerCLI cli = null;
        try {
            cli = SnazAppServerCLI.parse(args);
            if (cli.getMissingOptions().length > 0) {
                throw new ParseException("Missing required options: " + cli.formatMissingOptions(", "));
            }
            File serverConfig = cli.getServerConfigFile();
            IAppServerConfiguration appserverConfig = null;
            String[] environments = cli.getEnvironment();
            File installDir = new File(cli.getBaseDir(), "install");
            File workDir = new File(cli.getBaseDir(), "work");
            String zipFilePath = cli.getInstallZipFile();
            if (zipFilePath != null) {
                File zipFile = new File(zipFilePath);
                if (!zipFile.exists()) {
                    System.err.println("file does not exist: " + zipFilePath);
                    System.exit(-3);
                } else {
                    appserverConfig = ApplicationInstaller.installApplicationZipFile(zipFilePath, installDir, serverConfig, environments);
                    LocalRepository repository = cli.getRepositoryPath() != null ? new LocalRepository(new File(cli.getRepositoryPath())) : new LocalRepository();
                    SnazAppServer.fetchModules(appserverConfig, repository);
                }
            } else {
                if (!installDir.exists()) {
                    System.err.println("application is not installed in working dir, use the -install flag");
                    System.exit(-3);
                }
                appserverConfig = ApplicationInstaller.getInstalledConfiguration(installDir, serverConfig, environments);
                final SnazAppServer server = new SnazAppServer(installDir.getAbsolutePath(), workDir.getAbsolutePath(), SnazAppServer.class.getClassLoader(), new String[0], cli.getPort(), appserverConfig, cli.getRepositoryPath());
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        server.stop();
                    }
                });
                server.start();
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            if (cli != null) {
                cli.printHelp();
            }
            System.exit(-1);
        }
        catch (Throwable th) {
            System.err.println("Server startup failed");
            th.printStackTrace();
        }
    }

    private static void fetchModules(IAppServerConfiguration appServerConfig, LocalRepository repository) {
        SnazAppServer.fetchModules(repository, appServerConfig.getDependencies());
        for (WebConfig webconfig : appServerConfig.getAppConfiguration().getWebConfigs()) {
            List<DependencyConfig> dependencies = webconfig.getDependencies();
            SnazAppServer.fetchModules(repository, dependencies);
        }
    }

    private static void fetchModules(LocalRepository repository, List<DependencyConfig> dependencies) {
        for (DependencyConfig dependency : dependencies) {
            try {
                repository.getModuleZip(dependency.getOrg(), dependency.getName(), dependency.getRev());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

