/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver;

import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.IEngineFactory;
import com.staxnet.appserver.TomcatServerBase;
import com.staxnet.jdbc.Driver;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import net.stax.appserver.admin.AdminEngine;
import net.stax.appserver.webapp.WebAppEngine;
import org.apache.catalina.startup.Embedded;

public abstract class StaxAppServerBase
extends TomcatServerBase {
    protected static IAppServerConfiguration appServerConfig;
    private IEngineFactory[] engineFactories;
    protected static Logger logger;

    public StaxAppServerBase(String basePath, String workingDir, ClassLoader classloader, String[] classpath, int port, IAppServerConfiguration config, String localRepositoryPath) {
        appServerConfig = config;
        File baseDir = new File(basePath);
        if (appServerConfig.getDriverCallbackBaseUrl() != null) {
            Driver.getDatabaseConnectInfoBaseURL = appServerConfig.getDriverCallbackBaseUrl();
        }
        ArrayList<IEngineFactory> engineList = new ArrayList<IEngineFactory>();
        if (appServerConfig.isAdminEngineEnabled()) {
            AdminEngine adminEngineFactory = new AdminEngine(config, port + 1000, port);
            engineList.add(adminEngineFactory);
        }
        WebAppEngine webappEngineFactory = new WebAppEngine(baseDir, this.catalinaHome, port, config, classloader, classpath, localRepositoryPath);
        engineList.add(webappEngineFactory);
        this.engineFactories = engineList.toArray(new IEngineFactory[0]);
        this.init(workingDir);
    }

    private void registerMBean(ClassLoader classloader, String className, String objectName) {
        try {
            Object mbean = classloader.loadClass(className).newInstance();
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, new ObjectName(objectName));
            logger.info("Loaded mbean: " + objectName);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to load mbean: " + objectName, e);
        }
    }

    public static IAppServerConfiguration getConfiguration() {
        return appServerConfig;
    }

    @Override
    protected void loadEngines(Embedded container) throws IOException, ServletException {
        try {
            for (IEngineFactory engineFactory : this.engineFactories) {
                engineFactory.createEngine(container);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public StaxAppServerBase() {
    }

    static {
        logger = Logger.getLogger("StaxAppServer");
        try {
            Class.forName("com.staxnet.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
    }
}

