/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver;

import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.StaxAppServerBase;
import com.staxnet.appserver.StaxSdkAppServerCLI;
import com.staxnet.appserver.WarBasedServerConfiguration;
import java.io.File;
import javax.servlet.ServletException;
import org.apache.commons.cli.ParseException;

public class StaxSdkAppServer
extends StaxAppServerBase {
    public StaxSdkAppServer(String baseDir, String workingDir, ClassLoader classloader, String[] classpath, int port, IAppServerConfiguration config, String localRepositoryPath) {
        super(baseDir, workingDir, classloader, classpath, port, config, localRepositoryPath);
    }

    public static void main(String[] args) {
        String[] classPaths = new String[]{};
        ClassLoader cl = StaxSdkAppServer.class.getClassLoader();
        StaxSdkAppServerCLI cli = null;
        try {
            cli = StaxSdkAppServer.launchServer(args, classPaths, cl);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            if (cli != null) {
                cli.printHelp();
            }
            System.exit(-1);
        }
        catch (Throwable e) {
            System.err.println("Server aborted");
            e.printStackTrace();
            System.exit(-2);
        }
    }

    public static StaxSdkAppServerCLI launchServer(String[] args, String[] classPaths, ClassLoader cl) throws ParseException, ServletException {
        StaxSdkAppServerCLI cli = StaxSdkAppServerCLI.parse(args);
        if (cli.getMissingOptions().length > 0) {
            throw new ParseException("Missing required options: " + cli.formatMissingOptions(", "));
        }
        String[] environments = cli.getEnvironment();
        File serverConfig = cli.getServerConfigFile();
        File baseDir = new File(cli.getBaseDir());
        File webRoot = new File(cli.getWebdir());
        File workDir = new File(baseDir, "work");
        File staxWebXml = new File(webRoot, "WEB-INF/cloudbees-web.xml");
        if (!staxWebXml.exists()) {
            staxWebXml = new File(webRoot, "WEB-INF/stax-web.xml");
        }
        IAppServerConfiguration config = WarBasedServerConfiguration.load(serverConfig, webRoot, staxWebXml, environments);
        final StaxSdkAppServer server = new StaxSdkAppServer(baseDir.getAbsolutePath(), workDir.getAbsolutePath(), cl, classPaths, cli.getPort(), config, cli.getRepositoryPath());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                server.stop();
            }
        });
        server.start();
        return cli;
    }
}

