/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver;

import com.staxnet.appserver.I18NObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Embedded;

public abstract class TomcatServerBase
extends I18NObject {
    protected String catalinaHome;
    private Embedded container;
    protected static Logger logger = Logger.getLogger("appserver");

    protected TomcatServerBase() {
    }

    protected void init(String catalinaHome) {
        this.catalinaHome = catalinaHome;
    }

    private void initConfiguration() throws IOException {
        File configurationDirFile = new File(this.catalinaHome);
        if (configurationDirFile.exists()) {
            logger.info(this.getMessage("TomcatServerBase.usingConfiguration", this.catalinaHome));
        } else {
            logger.info(this.getMessage("TomcatServerBase.creatingConfiguration", this.catalinaHome));
            configurationDirFile.mkdirs();
            File confDir = new File(configurationDirFile, "conf");
            confDir.mkdir();
            this.copyFile("/conf/tomcat-users.xml", new File(confDir, "tomcat-users.xml"));
            this.copyFile("/conf/web.xml", new File(confDir, "web.xml"));
            File webappsDir = new File(configurationDirFile, "webapps");
            webappsDir.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String fromPath, File toFile) throws IOException {
        InputStream resourceInput = this.getClass().getResourceAsStream(fromPath);
        if (resourceInput == null) {
            throw new FileNotFoundException(fromPath);
        }
        try {
            FileOutputStream resourceOutput = new FileOutputStream(toFile);
            try {
                byte[] bytes = new byte[1024];
                int numRead = resourceInput.read(bytes);
                while (numRead != -1) {
                    ((OutputStream)resourceOutput).write(bytes, 0, numRead);
                    numRead = resourceInput.read(bytes);
                }
            }
            finally {
                ((OutputStream)resourceOutput).close();
            }
        }
        finally {
            resourceInput.close();
        }
    }

    private void startContainer() throws IOException, LifecycleException, ServletException {
        this.container = this.createContainer();
        this.container.setCatalinaHome(this.catalinaHome);
        this.loadEngines(this.container);
        this.container.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TomcatServerBase.this.stopContainer();
            }
        });
    }

    protected abstract void loadEngines(Embedded var1) throws IOException, ServletException;

    protected Embedded createContainer() {
        return new Embedded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIndefinitely() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException exception) {
                logger.log(Level.WARNING, this.getMessage("TomcatServerBase.interrupted"), exception);
            }
        }
    }

    public void stop() {
        this.stopContainer();
    }

    private void stopContainer() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (LifecycleException exception) {
            logger.log(Level.WARNING, this.getMessage("TomcatServerBase.cannotStop"), exception);
        }
    }

    public void start() throws ServletException {
        try {
            this.initConfiguration();
            this.startContainer();
            this.waitIndefinitely();
        }
        catch (LifecycleException exception) {
            throw new ServletException(this.getMessage("TomcatServerBase.cannotStart"), (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ServletException(this.getMessage("TomcatServerBase.cannotCreateConfiguration"), (Throwable)exception);
        }
    }
}

