/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver;

import com.staxnet.appserver.IAppConfiguration;
import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.AppConfigHelper;
import com.staxnet.appserver.config.AppServerConfig;
import com.staxnet.appserver.config.ContextParamConfig;
import com.staxnet.appserver.config.DependencyConfig;
import com.staxnet.appserver.config.HttpConfig;
import com.staxnet.appserver.config.RealmConfig;
import com.staxnet.appserver.config.ResourceConfig;
import com.staxnet.appserver.config.ServerParams;
import com.staxnet.appserver.config.SessionConfig;
import com.staxnet.appserver.config.WebConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WarBasedServerConfiguration
implements IAppServerConfiguration,
IAppConfiguration {
    private AppServerConfig appServerConfig;
    private AppConfig appConfig;
    protected static Logger logger = Logger.getLogger(WarBasedServerConfiguration.class.getName());

    private WarBasedServerConfiguration() {
    }

    public static IAppServerConfiguration load(File serverXmlFile, File webAppRoot, File staxWebAppXmlFile, String[] environments) {
        WarBasedServerConfiguration appserverConfig;
        WarBasedServerConfiguration warBasedServerConfiguration = appserverConfig = new WarBasedServerConfiguration();
        warBasedServerConfiguration.getClass();
        AppServerConfigurationLoader loader = warBasedServerConfiguration.new AppServerConfigurationLoader(appserverConfig);
        loader.loadV2(serverXmlFile, webAppRoot, staxWebAppXmlFile, environments);
        return appserverConfig;
    }

    @Override
    public IAppConfiguration getAppConfiguration() {
        return this;
    }

    @Override
    public RealmConfig getRealm() {
        return this.appConfig.getRealm();
    }

    @Override
    public List<ResourceConfig> getResources() {
        return this.appConfig.getResources();
    }

    @Override
    public List<WebConfig> getWebConfigs() {
        return this.appConfig.getWebConfigs();
    }

    @Override
    public String getApplicationId() {
        return this.appConfig.getApplicationId();
    }

    @Override
    public String getSessionDataSource() {
        return this.appConfig.getSessionDataSource();
    }

    @Override
    public String getServerCallbackAuthToken() {
        return this.appServerConfig.getServerCallbackAuthToken();
    }

    @Override
    public String getServerCallbackUrl() {
        return this.appServerConfig.getServerCallbackUrl();
    }

    @Override
    public List<DependencyConfig> getDependencies() {
        return this.appConfig.getDependencies();
    }

    @Override
    public String getDriverCallbackBaseUrl() {
        return this.appServerConfig.getDriverCallbackBaseUrl();
    }

    @Override
    public int getStatusInterval() {
        return this.appServerConfig.getStatusInterval();
    }

    @Override
    public String getColdFusionLicense() {
        return this.appServerConfig.getColdFusionLicense();
    }

    @Override
    public HttpConfig getHttpConfig() {
        return this.appServerConfig.getHttpConfig();
    }

    @Override
    public ServerParams getServerParams() {
        return this.appServerConfig.getServerParams();
    }

    @Override
    public boolean isAdminEngineEnabled() {
        return this.appServerConfig.isAdminEngineEnabled();
    }

    @Override
    public SessionConfig getSessionPersistence() {
        return this.appServerConfig.getSessionPersistence();
    }

    @Override
    public boolean isReloadEnabled() {
        return this.appServerConfig.isReloadEnabled();
    }

    @Override
    public boolean isPrivate() {
        return "private".equals(this.appServerConfig.getSecurityMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAppServerConfig(File configFile) {
        this.appServerConfig = new AppServerConfig();
        InputStream input = null;
        if (configFile != null && configFile.exists()) {
            try {
                logger.info("loading app config: " + configFile.getAbsolutePath());
                File xmlFile = configFile;
                input = new FileInputStream(xmlFile);
            }
            catch (FileNotFoundException e1) {
                // empty catch block
            }
        }
        if (input == null) {
            if (configFile != null && !configFile.exists()) {
                logger.log(Level.WARNING, "server config file does not exist: " + configFile.getAbsolutePath());
            }
            input = this.getClass().getResourceAsStream("/conf/appserver.xml");
        }
        try {
            this.appServerConfig = AppServerConfig.load(input);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error closing config file", e);
            }
        }
    }

    private class AppServerConfigurationLoader {
        private WarBasedServerConfiguration appserverConfig;

        public AppServerConfigurationLoader(WarBasedServerConfiguration appserverConfig) {
            this.appserverConfig = appserverConfig;
        }

        public void loadV2(File serverXmlFile, File webappRoot, File staxWebAppXmlFile, String[] environments) {
            String webappRootPath;
            this.appserverConfig.appConfig = new AppConfig();
            String string = webappRootPath = webappRoot != null ? webappRoot.getAbsolutePath() : null;
            if (staxWebAppXmlFile != null && staxWebAppXmlFile.exists()) {
                AppConfigHelper.load(this.appserverConfig.appConfig, staxWebAppXmlFile.getAbsolutePath(), environments, new String[0]);
            } else {
                WebConfig webconfig = new WebConfig(webappRootPath, "", new ArrayList<ContextParamConfig>());
                WarBasedServerConfiguration.this.appConfig.getWebConfigs().add(webconfig);
            }
            this.appserverConfig.readAppServerConfig(serverXmlFile);
        }
    }
}

