/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.IAppConfiguration;
import com.staxnet.appserver.config.ContextParamConfig;
import com.staxnet.appserver.config.DependencyConfig;
import com.staxnet.appserver.config.ParamConfig;
import com.staxnet.appserver.config.RealmConfig;
import com.staxnet.appserver.config.ResourceConfig;
import com.staxnet.appserver.config.UrlMappingConfig;
import com.staxnet.appserver.config.WebConfig;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="stax-application")
public class AppConfig
implements IAppConfiguration {
    @XStreamImplicit(itemFieldName="resource")
    private List<ResourceConfig> resources = new ArrayList<ResourceConfig>();
    @XStreamAlias(value="realm")
    private RealmConfig realm;
    @XStreamImplicit(itemFieldName="web")
    private List<WebConfig> webConfigs = new ArrayList<WebConfig>();
    @XStreamAlias(value="appid")
    private String applicationId;
    @XStreamAlias(value="default")
    private String defaultEnvironment;
    @XStreamAlias(value="sessionDataSource")
    private String sessionDataSource;
    @XStreamOmitField
    private List<String> appliedEnvironments = new ArrayList<String>();
    @XStreamAlias(value="dependencies")
    private List<DependencyConfig> dependencies = new ArrayList<DependencyConfig>();

    public AppConfig() {
    }

    public AppConfig(List<ResourceConfig> resources, RealmConfig realm, List<WebConfig> webConfigs) {
        this.resources = resources;
        this.realm = realm;
        this.webConfigs = webConfigs;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    public void setDefaultEnvironment(String defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    public List<DependencyConfig> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<DependencyConfig> dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public String getSessionDataSource() {
        return this.sessionDataSource;
    }

    public void setSessionDataSource(String sessionDataSource) {
        this.sessionDataSource = sessionDataSource;
    }

    public WebConfig getWebConfig(String contextPath) {
        for (WebConfig webconfig : this.webConfigs) {
            if (!webconfig.getContextRoot().equals(contextPath)) continue;
            return webconfig;
        }
        return null;
    }

    public ResourceConfig getResource(String resourceName) {
        for (ResourceConfig resource : this.resources) {
            if (!resource.getName().equals(resourceName)) continue;
            return resource;
        }
        return null;
    }

    public void addOrUpdateResource(ResourceConfig resource) {
        for (int i = 0; i < this.resources.size(); ++i) {
            ResourceConfig r = this.resources.get(i);
            if (!r.getName().equals(resource.getName())) continue;
            this.resources.set(i, resource);
            return;
        }
        this.resources.add(resource);
    }

    private static XStream createXStream() {
        XStream xstream = new XStream();
        xstream.processAnnotations(AppConfig.class);
        xstream.processAnnotations(WebConfig.class);
        xstream.processAnnotations(ResourceConfig.class);
        xstream.processAnnotations(RealmConfig.class);
        xstream.processAnnotations(ParamConfig.class);
        xstream.processAnnotations(ContextParamConfig.class);
        xstream.processAnnotations(UrlMappingConfig.class);
        return xstream;
    }

    public static void save(AppConfig appConfig, OutputStream out) {
        XStream xstream = AppConfig.createXStream();
        xstream.toXML((Object)appConfig, out);
    }

    public static String toXML(AppConfig appConfig) {
        XStream xstream = AppConfig.createXStream();
        return xstream.toXML((Object)appConfig);
    }

    @Override
    public List<ResourceConfig> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceConfig>();
        }
        return this.resources;
    }

    public void setResources(List<ResourceConfig> resources) {
        this.resources = resources;
    }

    @Override
    public RealmConfig getRealm() {
        return this.realm;
    }

    public void setRealm(RealmConfig realm) {
        this.realm = realm;
    }

    @Override
    public List<WebConfig> getWebConfigs() {
        if (this.webConfigs == null) {
            this.webConfigs = new ArrayList<WebConfig>();
        }
        return this.webConfigs;
    }

    public void setWebConfigs(List<WebConfig> webConfigs) {
        this.webConfigs = webConfigs;
    }

    public List<String> getAppliedEnvironments() {
        return this.appliedEnvironments;
    }

    public void setAppliedEnvironments(List<String> appliedEnvironments) {
        this.appliedEnvironments = appliedEnvironments;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applicationId == null ? 0 : this.applicationId.hashCode());
        result = 31 * result + (this.appliedEnvironments == null ? 0 : ((Object)this.appliedEnvironments).hashCode());
        result = 31 * result + (this.defaultEnvironment == null ? 0 : this.defaultEnvironment.hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : ((Object)this.dependencies).hashCode());
        result = 31 * result + (this.realm == null ? 0 : this.realm.hashCode());
        result = 31 * result + (this.resources == null ? 0 : ((Object)this.resources).hashCode());
        result = 31 * result + (this.sessionDataSource == null ? 0 : this.sessionDataSource.hashCode());
        result = 31 * result + (this.webConfigs == null ? 0 : ((Object)this.webConfigs).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppConfig other = (AppConfig)obj;
        if (this.applicationId == null ? other.applicationId != null : !this.applicationId.equals(other.applicationId)) {
            return false;
        }
        if (this.appliedEnvironments == null ? other.appliedEnvironments != null : !((Object)this.appliedEnvironments).equals(other.appliedEnvironments)) {
            return false;
        }
        if (this.defaultEnvironment == null ? other.defaultEnvironment != null : !this.defaultEnvironment.equals(other.defaultEnvironment)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !((Object)this.dependencies).equals(other.dependencies)) {
            return false;
        }
        if (this.realm == null ? other.realm != null : !this.realm.equals(other.realm)) {
            return false;
        }
        if (this.resources == null ? other.resources != null : !((Object)this.resources).equals(other.resources)) {
            return false;
        }
        if (this.sessionDataSource == null ? other.sessionDataSource != null : !this.sessionDataSource.equals(other.sessionDataSource)) {
            return false;
        }
        return !(this.webConfigs == null ? other.webConfigs != null : !((Object)this.webConfigs).equals(other.webConfigs));
    }
}

