/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.HttpConfig;
import com.staxnet.appserver.config.ServerParams;
import com.staxnet.appserver.config.SessionConfig;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

@XStreamAlias(value="appserver")
public class AppServerConfig {
    private String serverCallbackUrl = null;
    private String serverCallbackAuthToken = null;
    private String coldfusionLicense = null;
    private int statusInterval;
    private String securityMode;
    @XStreamAlias(value="http-connector")
    private HttpConfig httpConfig;
    @XStreamAlias(value="server-params")
    private ServerParams serverParams;
    private boolean adminEngineEnabled;
    private Boolean reloadEnabled;
    @XStreamAlias(value="session-persistence")
    private SessionConfig sessionPersistence;

    public SessionConfig getSessionPersistence() {
        return this.sessionPersistence;
    }

    public void setSessionPersistence(SessionConfig sessionPersistence) {
        this.sessionPersistence = sessionPersistence;
    }

    private void setDefaults() {
        this.statusInterval = this.statusInterval != 0 ? this.statusInterval : 60;
        this.securityMode = this.securityMode == null ? "public" : this.securityMode;
        this.httpConfig = this.httpConfig == null ? new HttpConfig() : this.httpConfig;
        this.serverParams = this.serverParams == null ? new ServerParams() : this.serverParams;
        this.reloadEnabled = this.reloadEnabled == null ? true : this.reloadEnabled;
    }

    public String getServerCallbackUrl() {
        return this.serverCallbackUrl;
    }

    public String getDriverCallbackBaseUrl() {
        String callbackHost = "api.stax.net";
        if (this.serverCallbackUrl != null) {
            try {
                callbackHost = new URL(this.getServerCallbackUrl()).getHost();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return "http://" + callbackHost + "/";
    }

    public String getServerCallbackAuthToken() {
        return this.serverCallbackAuthToken;
    }

    public String getColdFusionLicense() {
        return this.coldfusionLicense;
    }

    public int getStatusInterval() {
        return this.statusInterval;
    }

    public String getSecurityMode() {
        return this.securityMode;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public ServerParams getServerParams() {
        return this.serverParams;
    }

    public boolean isAdminEngineEnabled() {
        return this.adminEngineEnabled;
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setServerParams(ServerParams params) {
        this.serverParams = params;
    }

    public static AppServerConfig load(InputStream in) {
        XStream xstream = AppServerConfig.createXStream();
        AppServerConfig appConfig = (AppServerConfig)xstream.fromXML(in);
        appConfig.setDefaults();
        return appConfig;
    }

    private static XStream createXStream() {
        XStream xstream = new XStream();
        xstream.processAnnotations(AppServerConfig.class);
        xstream.processAnnotations(HttpConfig.class);
        xstream.processAnnotations(ServerParams.class);
        xstream.processAnnotations(SessionConfig.class);
        return xstream;
    }

    public static void save(AppConfig appConfig, OutputStream out) {
        XStream xstream = AppServerConfig.createXStream();
        xstream.toXML((Object)appConfig, out);
    }

    public static String toXML(AppConfig appConfig) {
        XStream xstream = AppServerConfig.createXStream();
        return xstream.toXML((Object)appConfig);
    }
}

