/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.ModuleConfig;
import com.staxnet.appserver.utils.XmlHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ModuleParser {
    public void load(ModuleConfig moduleConfig, String file) {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(file));
            InputSource input = new InputSource(inputStream);
            this.load(moduleConfig, input);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File does not exist: " + file);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void load(ModuleConfig moduleConfig, InputSource input) {
        Document doc = XmlHelper.readXML(input);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            Element e = doc.getDocumentElement();
            Node classpath = (Node)xpath.evaluate("//runtime/classpath", e, XPathConstants.NODE);
            NodeList nodes = (NodeList)xpath.evaluate("resource-uri", classpath, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                String nodeValue = xpath.evaluate("text()", n);
                moduleConfig.getClasspath().add(nodeValue);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }
}

