/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.ParamConfig;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;

public class ResourceConfig {
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String auth;
    @XStreamAsAttribute
    private String type;
    @XStreamImplicit(itemFieldName="param")
    private List<ParamConfig> parameters;

    public ResourceConfig(String name) {
        this.name = name;
        this.parameters = new ArrayList<ParamConfig>();
    }

    public ResourceConfig(String name, String auth, String type, List<ParamConfig> parameters) {
        this.name = name;
        this.auth = auth;
        this.type = type;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<ParamConfig> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParamConfig>();
        }
        return this.parameters;
    }

    public void setParameter(String name, String value) {
        ParamConfig paramConfig = this.getParam(name);
        if (paramConfig != null) {
            paramConfig.setValue(value);
        } else {
            this.addParameter(new ParamConfig(name, value));
        }
    }

    private void addParameter(ParamConfig param) {
        this.getParameters().add(param);
    }

    private ParamConfig getParam(String name) {
        for (ParamConfig param : this.getParameters()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.auth == null ? 0 : this.auth.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceConfig other = (ResourceConfig)obj;
        if (this.auth == null ? other.auth != null : !this.auth.equals(other.auth)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

