/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.ParamConfig;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="server-params")
public class ServerParams {
    @XStreamImplicit(itemFieldName="param")
    private List<ParamConfig> parameters;

    public List<ParamConfig> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParamConfig>();
        }
        return this.parameters;
    }

    public void setParameter(String name, String value) {
        ParamConfig paramConfig = this.getParam(name);
        if (paramConfig != null) {
            paramConfig.setValue(value);
        } else {
            this.addParameter(new ParamConfig(name, value));
        }
    }

    private ParamConfig getParam(String name) {
        for (ParamConfig param : this.getParameters()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public String getParamValue(String name, String defaultValue) {
        for (ParamConfig param : this.getParameters()) {
            if (!param.getName().equals(name)) continue;
            return param.getValue();
        }
        return defaultValue;
    }

    private void addParameter(ParamConfig param) {
        this.getParameters().add(param);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerParams other = (ServerParams)obj;
        return !(this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters));
    }
}

