/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.ParamConfig;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;

public class SessionConfig {
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String servers;
    @XStreamAsAttribute
    private String username;
    @XStreamAsAttribute
    private String password;
    @XStreamAsAttribute
    private String requestIgnorePattern;
    @XStreamAsAttribute
    private Boolean saveSessionAfterRequest;
    @XStreamAsAttribute
    private Boolean stickySession;
    @XStreamAsAttribute
    private Integer sessionMaxSize;
    @XStreamAsAttribute
    private Integer maxExpiration;
    @XStreamAsAttribute
    private Integer maxActiveSessions;
    @XStreamImplicit(itemFieldName="param")
    private List<ParamConfig> parameters;

    public SessionConfig(String name) {
        this.name = name;
        this.parameters = new ArrayList<ParamConfig>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRequestIgnorePattern() {
        return this.requestIgnorePattern;
    }

    public void setRequestIgnorePattern(String requestIgnorePattern) {
        this.requestIgnorePattern = requestIgnorePattern;
    }

    public Boolean getSaveSessionAfterRequest() {
        return this.saveSessionAfterRequest;
    }

    public void setSaveSessionAfterRequest(Boolean saveSessionAfterRequest) {
        this.saveSessionAfterRequest = saveSessionAfterRequest;
    }

    public Boolean getStickySession() {
        return this.stickySession;
    }

    public void setStickySession(Boolean stickySession) {
        this.stickySession = stickySession;
    }

    public Integer getSessionMaxSize() {
        return this.sessionMaxSize;
    }

    public void setSessionMaxSize(Integer sessionMaxSize) {
        this.sessionMaxSize = sessionMaxSize;
    }

    public Integer getMaxExpiration() {
        return this.maxExpiration;
    }

    public void setMaxExpiration(Integer maxExpiration) {
        this.maxExpiration = maxExpiration;
    }

    public Integer getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(Integer maxActiveSessions) {
        this.maxActiveSessions = maxActiveSessions;
    }

    public List<ParamConfig> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParamConfig>();
        }
        return this.parameters;
    }

    public void setParameter(String name, String value) {
        ParamConfig paramConfig = this.getParam(name);
        if (paramConfig != null) {
            paramConfig.setValue(value);
        } else {
            this.addParameter(new ParamConfig(name, value));
        }
    }

    private void addParameter(ParamConfig param) {
        this.getParameters().add(param);
    }

    private ParamConfig getParam(String name) {
        for (ParamConfig param : this.getParameters()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.servers == null ? 0 : this.servers.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.requestIgnorePattern == null ? 0 : this.requestIgnorePattern.hashCode());
        result = 31 * result + (this.saveSessionAfterRequest == null ? 0 : this.saveSessionAfterRequest.hashCode());
        result = 31 * result + (this.stickySession == null ? 0 : this.stickySession.hashCode());
        result = 31 * result + (this.sessionMaxSize == null ? 0 : this.sessionMaxSize.hashCode());
        result = 31 * result + (this.maxExpiration == null ? 0 : this.maxExpiration.hashCode());
        result = 31 * result + (this.maxActiveSessions == null ? 0 : this.maxActiveSessions.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionConfig other = (SessionConfig)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.servers == null ? other.servers != null : !this.servers.equals(other.servers)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.requestIgnorePattern == null ? other.requestIgnorePattern != null : !this.requestIgnorePattern.equals(other.requestIgnorePattern)) {
            return false;
        }
        if (this.saveSessionAfterRequest == null ? other.saveSessionAfterRequest != null : !this.saveSessionAfterRequest.equals(other.saveSessionAfterRequest)) {
            return false;
        }
        if (this.stickySession == null ? other.stickySession != null : !this.stickySession.equals(other.stickySession)) {
            return false;
        }
        if (this.sessionMaxSize == null ? other.sessionMaxSize != null : !this.sessionMaxSize.equals(other.sessionMaxSize)) {
            return false;
        }
        if (this.maxExpiration == null ? other.maxExpiration != null : !this.maxExpiration.equals(other.maxExpiration)) {
            return false;
        }
        if (this.maxActiveSessions == null ? other.maxActiveSessions != null : !this.maxActiveSessions.equals(other.maxActiveSessions)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters));
    }
}

