/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.ContextParamConfig;
import com.staxnet.appserver.config.DependencyConfig;
import com.staxnet.appserver.config.RealmConfig;
import com.staxnet.appserver.config.ResourceConfig;
import com.staxnet.appserver.config.UrlMappingConfig;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@XStreamAlias(value="stax-web-app")
public class WebAppConfig {
    @XStreamImplicit(itemFieldName="context-param")
    private List<ContextParamConfig> parameters;
    @XStreamAlias(value="dependencies")
    private List<DependencyConfig> dependencies = new ArrayList<DependencyConfig>();
    @XStreamImplicit(itemFieldName="resource")
    private List<ResourceConfig> resources = new ArrayList<ResourceConfig>();
    @XStreamAlias(value="realm")
    private RealmConfig realm;
    @XStreamAlias(value="default")
    private String defaultEnvironment;
    @XStreamAlias(value="sessionDataSource")
    private String sessionDataSource;
    @XStreamOmitField
    private Map<String, String> paramMap;

    public WebAppConfig(List<ResourceConfig> resources, RealmConfig realm, List<ContextParamConfig> parameters, ArrayList<UrlMappingConfig> mappings) {
        this.resources = resources;
        this.realm = realm;
        this.parameters = parameters;
    }

    public List<DependencyConfig> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<DependencyConfig> dependencies) {
        this.dependencies = dependencies;
    }

    public List<ContextParamConfig> getParameters() {
        return this.parameters;
    }

    public ResourceConfig getResource(String resourceName) {
        for (ResourceConfig resource : this.resources) {
            if (!resource.getName().equals(resourceName)) continue;
            return resource;
        }
        return null;
    }

    public void addOrUpdateResource(ResourceConfig resource) {
        for (int i = 0; i < this.resources.size(); ++i) {
            ResourceConfig r = this.resources.get(i);
            if (!r.getName().equals(resource.getName())) continue;
            this.resources.set(i, resource);
            return;
        }
        this.resources.add(resource);
    }

    public List<ResourceConfig> getResources() {
        return this.resources;
    }

    public void setResources(List<ResourceConfig> resources) {
        this.resources = resources;
    }

    public RealmConfig getRealm() {
        return this.realm;
    }

    public void setRealm(RealmConfig realm) {
        this.realm = realm;
    }

    public void setParameter(String name, String value, String description) {
        if (this.paramMap.containsKey(name)) {
            ContextParamConfig paramConfig = this.getContextParam(name);
            paramConfig.setValue(value);
            paramConfig.setDescription(description);
            this.paramMap.put(name, value);
        } else {
            this.parameters.add(new ContextParamConfig(name, value, description));
            this.paramMap.put(name, value);
        }
    }

    public Map<String, String> getParametersMap() {
        return this.paramMap;
    }

    private ContextParamConfig getContextParam(String name) {
        for (ContextParamConfig param : this.getParameters()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public String getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    public void setDefaultEnvironment(String defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    public String getSessionDataSource() {
        return this.sessionDataSource;
    }

    public void setSessionDataSource(String sessionDataSource) {
        this.sessionDataSource = sessionDataSource;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultEnvironment == null ? 0 : this.defaultEnvironment.hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : ((Object)this.dependencies).hashCode());
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        result = 31 * result + (this.realm == null ? 0 : this.realm.hashCode());
        result = 31 * result + (this.resources == null ? 0 : ((Object)this.resources).hashCode());
        result = 31 * result + (this.sessionDataSource == null ? 0 : this.sessionDataSource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebAppConfig other = (WebAppConfig)obj;
        if (this.defaultEnvironment == null ? other.defaultEnvironment != null : !this.defaultEnvironment.equals(other.defaultEnvironment)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !((Object)this.dependencies).equals(other.dependencies)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters)) {
            return false;
        }
        if (this.realm == null ? other.realm != null : !this.realm.equals(other.realm)) {
            return false;
        }
        if (this.resources == null ? other.resources != null : !((Object)this.resources).equals(other.resources)) {
            return false;
        }
        return !(this.sessionDataSource == null ? other.sessionDataSource != null : !this.sessionDataSource.equals(other.sessionDataSource));
    }
}

