/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.DependencyConfig;
import com.staxnet.appserver.config.RealmConfig;
import com.staxnet.appserver.config.ResourceConfig;
import com.staxnet.appserver.config.WebConfig;
import com.staxnet.appserver.utils.StringHelper;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebAppConfigParser {
    private String contextPath;
    private String webUri;

    public WebAppConfigParser(String contextPath, String webUri) {
        this.contextPath = contextPath;
        this.webUri = webUri;
    }

    public void load(AppConfig appConfig, Document doc, String[] environments, String[] implicitEnvironments) {
        WebConfig config = this.getOrCreateWebConfig(appConfig, this.contextPath);
        config.setWebUri(this.webUri);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            Element e = doc.getDocumentElement();
            this.applyToAppConfig(appConfig, xpath, e, this.contextPath);
            appConfig.setDefaultEnvironment(e.getAttribute("default"));
            environments = environments == null || environments.length == 0 ? WebAppConfigParser.getEnvironmentList(appConfig.getDefaultEnvironment(), implicitEnvironments) : WebAppConfigParser.getEnvironmentList(StringHelper.join(environments, ","), implicitEnvironments);
            NodeList nodes = (NodeList)xpath.evaluate("environment", e, XPathConstants.NODESET);
            HashMap<String, Node> envNodes = new HashMap<String, Node>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                String envName = this.getAttribute(n, "name", null);
                if (envName == null) {
                    throw new IllegalArgumentException("missing required attribute (name) on environent element");
                }
                envNodes.put(envName, n);
            }
            if (environments != null) {
                for (String env : environments) {
                    Node n = (Node)envNodes.get(env);
                    if (n == null) continue;
                    this.applyToAppConfig(appConfig, xpath, n, this.contextPath);
                    appConfig.getAppliedEnvironments().add(env);
                }
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void applyToAppConfig(AppConfig appConfig, XPath xpath, Node e, String contextPath) throws XPathExpressionException {
        String name;
        String sessionDataSource;
        String appId = this.getNodeValue(e, xpath, "appid", true);
        if (appId != null) {
            appConfig.setApplicationId(appId);
        }
        if ((sessionDataSource = this.getNodeValue(e, xpath, "sessionDataSource", true)) != null) {
            appConfig.setSessionDataSource(sessionDataSource);
        }
        NodeList globalDepedencyNodes = (NodeList)xpath.evaluate("dependencies/dependency", e, XPathConstants.NODESET);
        for (int j = 0; j < globalDepedencyNodes.getLength(); ++j) {
            Node dependencyNode = globalDepedencyNodes.item(j);
            String org = this.getAttribute(dependencyNode, "org", null);
            String name2 = this.getAttribute(dependencyNode, "name", null);
            String rev = this.getAttribute(dependencyNode, "rev", null);
            appConfig.getDependencies().add(new DependencyConfig(org, name2, rev));
        }
        WebConfig wc = this.getOrCreateWebConfig(appConfig, contextPath);
        NodeList contextParamNodes = (NodeList)xpath.evaluate("context-param", e, XPathConstants.NODESET);
        for (int j = 0; j < contextParamNodes.getLength(); ++j) {
            Node paramNode = contextParamNodes.item(j);
            String paramName = this.getNodeValue(paramNode, xpath, "param-name", true);
            String paramValue = this.getNodeValue(paramNode, xpath, "param-value", true);
            String description = this.getNodeValue(paramNode, xpath, "description", true);
            wc.setParameter(paramName, paramValue, description);
        }
        NodeList depedencyNodes = (NodeList)xpath.evaluate("dependencies/dependency", e, XPathConstants.NODESET);
        for (int j = 0; j < depedencyNodes.getLength(); ++j) {
            Node dependencyNode = depedencyNodes.item(j);
            String org = this.getAttribute(dependencyNode, "org", null);
            name = this.getAttribute(dependencyNode, "name", null);
            String rev = this.getAttribute(dependencyNode, "rev", null);
            wc.getDependencies().add(new DependencyConfig(org, name, rev));
        }
        NodeList nodes = (NodeList)xpath.evaluate("resource", e, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            name = this.getAttribute(node, "name", null);
            String auth = this.getAttribute(node, "auth", null);
            String type = this.getAttribute(node, "type", null);
            NodeList paramNodes = (NodeList)xpath.evaluate("param", node, XPathConstants.NODESET);
            ResourceConfig resource = new ResourceConfig(name);
            if (auth != null) {
                resource.setAuth(auth);
            }
            if (type != null) {
                resource.setType(type);
            }
            for (int paramIndex = 0; paramIndex < paramNodes.getLength(); ++paramIndex) {
                Node paramNode = paramNodes.item(paramIndex);
                String paramName = this.getAttribute(paramNode, "name", null);
                String paramValue = this.getAttribute(paramNode, "value", null);
                resource.setParameter(paramName, paramValue);
            }
            appConfig.addOrUpdateResource(resource);
        }
        nodes = (NodeList)xpath.evaluate("realm", e, XPathConstants.NODESET);
        if (nodes.getLength() > 1) {
            throw new IllegalArgumentException("Multiple realms cannot be declared");
        }
        if (nodes.getLength() == 1) {
            Node node = nodes.item(0);
            RealmConfig realm = new RealmConfig();
            NodeList paramNodes = (NodeList)xpath.evaluate("param", node, XPathConstants.NODESET);
            for (int paramIndex = 0; paramIndex < paramNodes.getLength(); ++paramIndex) {
                Node paramNode = paramNodes.item(paramIndex);
                String paramName = this.getAttribute(paramNode, "name", null);
                String paramValue = this.getAttribute(paramNode, "value", null);
                realm.setParameter(paramName, paramValue);
            }
            appConfig.setRealm(realm);
        }
    }

    private String getAttribute(Node node, String attr, String defaultValue) {
        Node attrNode = node.getAttributes().getNamedItem(attr);
        if (attrNode == null) {
            return defaultValue;
        }
        return attrNode.getNodeValue();
    }

    private String getNodeValue(Node node, XPath xpath, String expression, boolean trim) throws XPathExpressionException {
        Node n = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
        if (n == null) {
            return null;
        }
        String nodeValue = xpath.evaluate("text()", n);
        return nodeValue.trim();
    }

    private WebConfig getOrCreateWebConfig(AppConfig appConfig, String contextPath) {
        WebConfig wc = appConfig.getWebConfig(contextPath);
        if (wc == null) {
            wc = new WebConfig(contextPath);
            appConfig.getWebConfigs().add(wc);
        }
        return wc;
    }

    public static String[] getEnvironmentList(String environments, String ... prependEnvs) {
        int i;
        if (environments == null && prependEnvs.length == 0) {
            return new String[0];
        }
        if (environments == null) {
            environments = "";
        }
        String[] envSplit = environments.split(",");
        String[] envList = new String[envSplit.length + prependEnvs.length];
        for (i = 0; i < prependEnvs.length; ++i) {
            envList[i] = prependEnvs[i];
        }
        for (i = 0; i < envSplit.length; ++i) {
            envList[prependEnvs.length + i] = envSplit[i].trim();
        }
        return envList;
    }
}

