/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.jmx;

import com.staxnet.appserver.jmx.AppServerStats;
import com.staxnet.appserver.jmx.AppServerStatsTracker;
import com.staxnet.appserver.jmx.ApplicationObjectFactory;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.core.StandardContext;

public class AppManagementContext
implements ContainerListener {
    private static final String MBEAN_NAME = "net.stax:type=AppServer";
    private static Logger logger = Logger.getLogger(AppManagementContext.class.getName());
    private boolean initialized = false;

    public void containerEvent(ContainerEvent evt) {
        StandardContext context = (StandardContext)evt.getContainer();
        if (evt.getType().equals("beforeContextInitialized")) {
            if (!this.initialized) {
                this.initialized = true;
                this.onBeforeContextInitialized(context);
            }
        } else if (!evt.getType().equals("beforeContextDestroyed") && evt.getType().equals("afterContextDestroyed") && this.initialized) {
            this.initialized = false;
            this.onAfterContextDestroyed(context);
        }
    }

    private void onBeforeContextInitialized(StandardContext context) {
        ClassLoader apploader = context.getLoader().getClassLoader();
        AppServerStats stats = this.registerAppStats();
        ApplicationObjectFactory objectFactory = new ApplicationObjectFactory(apploader);
        this.hookLog4JEvents(apploader, stats, objectFactory);
    }

    private void hookLog4JEvents(ClassLoader apploader, AppServerStats stats, ApplicationObjectFactory objectFactory) {
        try {
            Class<?> cls = apploader.loadClass("org.apache.log4j.LogManager");
            logger.log(Level.FINE, "Found log4j classes");
            AppServerStatsTracker errorTracker = objectFactory.createApplicationObject("com.staxnet.appserver.jmx.Log4JErrorTracker", AppServerStatsTracker.class);
            errorTracker.init(stats);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Log4J was not found.", e);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not hook log4j errors", e);
        }
    }

    private AppServerStats registerAppStats() {
        try {
            AppServerStats mbean = new AppServerStats();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(MBEAN_NAME);
            mbs.registerMBean(mbean, objectName);
            return mbean;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "failed to load mbean: net.stax:type=AppServer", e);
            return null;
        }
    }

    private void onAfterContextDestroyed(StandardContext context) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(MBEAN_NAME);
            mbs.unregisterMBean(objectName);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "failed to unload mbean: net.stax:type=AppServer", e);
        }
    }
}

