/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.jmx;

import com.staxnet.appserver.jmx.AppServerStatsMBean;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.stax.appserver.admin.jmx.MBeanContainerResource;
import net.stax.appserver.admin.jmx.MBeanName;

public class AppServerStats
implements AppServerStatsMBean {
    private static Logger logger = Logger.getLogger(AppServerStats.class.getName());
    private String requestProcessorName;
    private String threadPoolName;
    private String engineManagerName = "localEngine:host=localhost,path=/,type=Manager";
    private MBeanContainerResource mbeans = new MBeanContainerResource();
    private long logErrorCount;

    @Override
    public long getRequestErrorCount() {
        return this.getRequestLong("errorCount");
    }

    @Override
    public long getBytesReceived() {
        return this.getRequestLong("bytesReceived");
    }

    @Override
    public long getBytesSent() {
        return this.getRequestLong("bytesSent");
    }

    @Override
    public long getRequestProcessingTime() {
        return this.getRequestLong("processingTime");
    }

    @Override
    public long getRequestCount() {
        return this.getRequestLong("requestCount");
    }

    @Override
    public long getMaxRequestTime() {
        return this.getRequestLong("maxTime");
    }

    @Override
    public long getSessionCount() {
        return this.getLong(this.engineManagerName, "sessionCounter");
    }

    @Override
    public long getActiveSessions() {
        return this.getLong(this.engineManagerName, "activeSessions");
    }

    @Override
    public long getExpiredSessions() {
        return this.getLong(this.engineManagerName, "expiredSessions");
    }

    @Override
    public long getMaxActiveSessions() {
        return this.getLong(this.engineManagerName, "maxActiveSessions");
    }

    @Override
    public long getRejectedSessions() {
        return this.getLong(this.engineManagerName, "rejectedSessions");
    }

    @Override
    public long getSessionAverageAliveTime() {
        return this.getLong(this.engineManagerName, "sessionAverageAliveTime");
    }

    @Override
    public long getMaxRequestThreads() {
        return this.getThreadPoolLong("maxThreads");
    }

    @Override
    public long getRequestThreadsBusy() {
        return this.getThreadPoolLong("currentThreadsBusy");
    }

    @Override
    public long getRequestThreadCount() {
        return this.getThreadPoolLong("currentThreadCount");
    }

    @Override
    public long getLogErrorCount() {
        return this.logErrorCount;
    }

    public synchronized void incrementLogErrorCount() {
        ++this.logErrorCount;
    }

    private long getLong(String name, String attribute) {
        try {
            return ((Number)this.mbeans.getAttribute(name, attribute)).longValue();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private long getRequestLong(String attribute) {
        if (this.requestProcessorName == null) {
            this.requestProcessorName = this.loadMBeanFromQuery("localEngine:type=GlobalRequestProcessor,*");
        }
        if (this.requestProcessorName != null) {
            return this.getLong(this.requestProcessorName, attribute);
        }
        return 0L;
    }

    private long getThreadPoolLong(String attribute) {
        if (this.threadPoolName == null) {
            this.threadPoolName = this.loadMBeanFromQuery("localEngine:type=ThreadPool,*");
        }
        if (this.threadPoolName != null) {
            return this.getLong(this.threadPoolName, attribute);
        }
        return 0L;
    }

    private String loadMBeanFromQuery(String query) {
        try {
            Collection<MBeanName> names = this.mbeans.getMBeans(query);
            if (names.size() > 0) {
                MBeanName name = names.toArray(new MBeanName[0])[0];
                return name.getName();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "failed to load mbean from query: " + query, e);
        }
        return null;
    }
}

