/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.jmx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ApplicationObjectFactory {
    private InjectableClassLoader loader;

    public ApplicationObjectFactory(ClassLoader parent) {
        this.loader = new InjectableClassLoader(parent);
    }

    public <T> T createApplicationObject(String className, Class<T> type) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> cls = this.loadApplicationClass(className);
        Object obj = cls.newInstance();
        return (T)obj;
    }

    public Class<?> loadApplicationClass(String className) throws ClassNotFoundException {
        String classFilePath = "/" + className.replace(".", "/") + ".class";
        InputStream res = this.getClass().getResourceAsStream(classFilePath);
        if (res != null) {
            try {
                this.loader.injectClass(className, res, true);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return this.loader.loadClass(className);
    }

    class InjectableClassLoader
    extends ClassLoader {
        private ClassLoader parent;
        private HashMap<String, byte[]> injectedClasses;
        private HashMap<String, Class<?>> loadedClasses;

        public InjectableClassLoader(ClassLoader parent) {
            super(parent);
            this.injectedClasses = new HashMap();
            this.loadedClasses = new HashMap();
            this.parent = parent;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.injectedClasses.containsKey(name)) {
                return this.initClass(name, resolve);
            }
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException e) {
                return this.initClass(name, resolve);
            }
        }

        private Class<?> initClass(String name, boolean resolve) throws ClassFormatError, ClassNotFoundException {
            Class<?> cls = null;
            if (this.loadedClasses.containsKey(name)) {
                cls = this.loadedClasses.get(name);
            } else if (this.injectedClasses.containsKey(name)) {
                byte[] classBytes = this.injectedClasses.get(name);
                cls = this.defineClass(name, classBytes, 0, classBytes.length);
                this.loadedClasses.put(name, cls);
                this.injectedClasses.remove(name);
            }
            if (cls != null) {
                if (resolve) {
                    this.resolveClass(cls);
                }
                return cls;
            }
            throw new ClassNotFoundException(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void injectClass(String className, InputStream in, boolean closeStream) throws IOException {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                int numRead = in.read(bytes);
                while (numRead != -1) {
                    bout.write(bytes, 0, numRead);
                    numRead = in.read(bytes);
                }
                byte[] classBytes = bout.toByteArray();
                this.injectClass(className, classBytes);
            }
            finally {
                if (closeStream) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }

        public void injectClass(String className, byte[] bytes) {
            this.injectedClasses.put(className, bytes);
        }
    }
}

