/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.CustomObjectInputStream;

public class StaxSessionStore
extends StoreBase
implements Store {
    protected static String info = "StaxSessionStore/1.0";
    private String name = null;
    protected static String storeName = "JDBCStore";
    protected String threadName = "StaxSessionStore";
    private Connection dbConnection = null;
    protected String dataSourceName = null;
    protected String sessionTable = "stax_sessions";
    protected String sessionAppCol = "app";
    protected String sessionIdCol = "id";
    protected String sessionDataCol = "data";
    protected String sessionValidCol = "valid";
    protected String sessionMaxInactiveCol = "maxinactive";
    protected String sessionLastAccessedCol = "lastaccess";
    protected PreparedStatement preparedSizeSql = null;
    protected PreparedStatement preparedKeysSql = null;
    protected PreparedStatement preparedSaveSql = null;
    protected PreparedStatement preparedClearSql = null;
    protected PreparedStatement preparedRemoveSql = null;
    protected PreparedStatement preparedLoadSql = null;
    protected DataSource datasource;

    public String getInfo() {
        return info;
    }

    public String getName() {
        if (this.name == null) {
            Container container = this.manager.getContainer();
            String contextName = container.getName();
            String hostName = "";
            String engineName = "";
            if (container.getParent() != null) {
                Container host = container.getParent();
                hostName = host.getName();
                if (host.getParent() != null) {
                    engineName = host.getParent().getName();
                }
            }
            this.name = "/" + engineName + "/" + hostName + contextName;
        }
        return this.name;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDataSourceName(String dataSourceName) {
        String oldDataSourceName = this.dataSourceName;
        this.dataSourceName = dataSourceName;
        this.support.firePropertyChange("dataSourceName", oldDataSourceName, this.dataSourceName);
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setSessionTable(String sessionTable) {
        String oldSessionTable = this.sessionTable;
        this.sessionTable = sessionTable;
        this.support.firePropertyChange("sessionTable", oldSessionTable, this.sessionTable);
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionAppCol(String sessionAppCol) {
        String oldSessionAppCol = this.sessionAppCol;
        this.sessionAppCol = sessionAppCol;
        this.support.firePropertyChange("sessionAppCol", oldSessionAppCol, this.sessionAppCol);
    }

    public String getSessionAppCol() {
        return this.sessionAppCol;
    }

    public void setSessionIdCol(String sessionIdCol) {
        String oldSessionIdCol = this.sessionIdCol;
        this.sessionIdCol = sessionIdCol;
        this.support.firePropertyChange("sessionIdCol", oldSessionIdCol, this.sessionIdCol);
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionDataCol(String sessionDataCol) {
        String oldSessionDataCol = this.sessionDataCol;
        this.sessionDataCol = sessionDataCol;
        this.support.firePropertyChange("sessionDataCol", oldSessionDataCol, this.sessionDataCol);
    }

    public String getSessionDataCol() {
        return this.sessionDataCol;
    }

    public void setSessionValidCol(String sessionValidCol) {
        String oldSessionValidCol = this.sessionValidCol;
        this.sessionValidCol = sessionValidCol;
        this.support.firePropertyChange("sessionValidCol", oldSessionValidCol, this.sessionValidCol);
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionMaxInactiveCol(String sessionMaxInactiveCol) {
        String oldSessionMaxInactiveCol = this.sessionMaxInactiveCol;
        this.sessionMaxInactiveCol = sessionMaxInactiveCol;
        this.support.firePropertyChange("sessionMaxInactiveCol", oldSessionMaxInactiveCol, this.sessionMaxInactiveCol);
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionLastAccessedCol(String sessionLastAccessedCol) {
        String oldSessionLastAccessedCol = this.sessionLastAccessedCol;
        this.sessionLastAccessedCol = sessionLastAccessedCol;
        this.support.firePropertyChange("sessionLastAccessedCol", oldSessionLastAccessedCol, this.sessionLastAccessedCol);
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] keys() throws IOException {
        ResultSet rst = null;
        String[] keys = null;
        StaxSessionStore staxSessionStore = this;
        synchronized (staxSessionStore) {
            for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
                Connection _conn = this.getConnection();
                if (_conn == null) {
                    return new String[0];
                }
                try {
                    if (this.preparedKeysSql == null) {
                        String keysSql = "SELECT " + this.sessionIdCol + " FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                        this.preparedKeysSql = _conn.prepareStatement(keysSql);
                    }
                    this.preparedKeysSql.setString(1, this.getName());
                    rst = this.preparedKeysSql.executeQuery();
                    ArrayList<String> tmpkeys = new ArrayList<String>();
                    if (rst != null) {
                        while (rst.next()) {
                            tmpkeys.add(rst.getString(1));
                        }
                    }
                    keys = tmpkeys.toArray(new String[tmpkeys.size()]);
                    numberOfTries = 0;
                    continue;
                }
                catch (SQLException e) {
                    this.manager.getContainer().getLogger().error((Object)this.sm.getString(this.getStoreName() + ".SQLException", (Object)e));
                    keys = new String[]{};
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    try {
                        if (rst != null) {
                            rst.close();
                        }
                    }
                    catch (SQLException e) {}
                    this.release(_conn);
                }
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws IOException {
        int size = 0;
        ResultSet rst = null;
        StaxSessionStore staxSessionStore = this;
        synchronized (staxSessionStore) {
            for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
                Connection _conn = this.getConnection();
                if (_conn == null) {
                    return size;
                }
                try {
                    if (this.preparedSizeSql == null) {
                        String sizeSql = "SELECT COUNT(" + this.sessionIdCol + ") FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                        this.preparedSizeSql = _conn.prepareStatement(sizeSql);
                    }
                    this.preparedSizeSql.setString(1, this.getName());
                    rst = this.preparedSizeSql.executeQuery();
                    if (rst.next()) {
                        size = rst.getInt(1);
                    }
                    numberOfTries = 0;
                    continue;
                }
                catch (SQLException e) {
                    this.manager.getContainer().getLogger().error((Object)this.sm.getString(this.getStoreName() + ".SQLException", (Object)e));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    try {
                        if (rst != null) {
                            rst.close();
                        }
                    }
                    catch (SQLException e) {}
                    this.release(_conn);
                }
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session load(String id) throws ClassNotFoundException, IOException {
        ResultSet rst = null;
        StandardSession _session = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        ObjectInputStream ois = null;
        BufferedInputStream bis = null;
        Container container = this.manager.getContainer();
        StaxSessionStore staxSessionStore = this;
        synchronized (staxSessionStore) {
            for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
                Connection _conn = this.getConnection();
                if (_conn == null) {
                    return null;
                }
                try {
                    if (this.preparedLoadSql == null) {
                        String loadSql = "SELECT " + this.sessionIdCol + ", " + this.sessionDataCol + " FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ? AND " + this.sessionAppCol + " = ?";
                        this.preparedLoadSql = _conn.prepareStatement(loadSql);
                    }
                    this.preparedLoadSql.setString(1, id);
                    this.preparedLoadSql.setString(2, this.getName());
                    rst = this.preparedLoadSql.executeQuery();
                    if (rst.next()) {
                        bis = new BufferedInputStream(rst.getBinaryStream(2));
                        if (container != null) {
                            loader = container.getLoader();
                        }
                        if (loader != null) {
                            classLoader = loader.getClassLoader();
                        }
                        ois = classLoader != null ? new CustomObjectInputStream((InputStream)bis, classLoader) : new ObjectInputStream(bis);
                        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
                            this.manager.getContainer().getLogger().debug((Object)this.sm.getString(this.getStoreName() + ".loading", (Object)id, (Object)this.sessionTable));
                        }
                        _session = (StandardSession)this.manager.createEmptySession();
                        _session.readObjectData(ois);
                        _session.setManager(this.manager);
                    } else if (this.manager.getContainer().getLogger().isDebugEnabled()) {
                        this.manager.getContainer().getLogger().debug((Object)(this.getStoreName() + ": No persisted data object found"));
                    }
                    numberOfTries = 0;
                    continue;
                }
                catch (SQLException e) {
                    this.manager.getContainer().getLogger().error((Object)this.sm.getString(this.getStoreName() + ".SQLException", (Object)e));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    try {
                        if (rst != null) {
                            rst.close();
                        }
                    }
                    catch (SQLException e) {}
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException e) {}
                    }
                    this.release(_conn);
                }
            }
        }
        return _session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) throws IOException {
        StaxSessionStore staxSessionStore = this;
        synchronized (staxSessionStore) {
            for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
                Connection _conn = this.getConnection();
                if (_conn == null) {
                    return;
                }
                try {
                    if (this.preparedRemoveSql == null) {
                        String removeSql = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?  AND " + this.sessionAppCol + " = ?";
                        this.preparedRemoveSql = _conn.prepareStatement(removeSql);
                    }
                    this.preparedRemoveSql.setString(1, id);
                    this.preparedRemoveSql.setString(2, this.getName());
                    this.preparedRemoveSql.execute();
                    numberOfTries = 0;
                    continue;
                }
                catch (SQLException e) {
                    this.manager.getContainer().getLogger().error((Object)this.sm.getString(this.getStoreName() + ".SQLException", (Object)e));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    this.release(_conn);
                }
            }
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)this.sm.getString(this.getStoreName() + ".removing", (Object)id, (Object)this.sessionTable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        StaxSessionStore staxSessionStore = this;
        synchronized (staxSessionStore) {
            for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
                Connection _conn = this.getConnection();
                if (_conn == null) {
                    return;
                }
                try {
                    if (this.preparedClearSql == null) {
                        String clearSql = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                        this.preparedClearSql = _conn.prepareStatement(clearSql);
                    }
                    this.preparedClearSql.setString(1, this.getName());
                    this.preparedClearSql.execute();
                    numberOfTries = 0;
                    continue;
                }
                catch (SQLException e) {
                    this.manager.getContainer().getLogger().error((Object)this.sm.getString(this.getStoreName() + ".SQLException", (Object)e));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    this.release(_conn);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Session session) throws IOException {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        ByteArrayInputStream bis = null;
        InputStream in = null;
        StaxSessionStore staxSessionStore = this;
        synchronized (staxSessionStore) {
            for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
                Connection _conn = this.getConnection();
                if (_conn == null) {
                    return;
                }
                this.remove(session.getIdInternal());
                try {
                    bos = new ByteArrayOutputStream();
                    oos = new ObjectOutputStream(new BufferedOutputStream(bos));
                    ((StandardSession)session).writeObjectData(oos);
                    oos.close();
                    oos = null;
                    byte[] obs = bos.toByteArray();
                    int size = obs.length;
                    bis = new ByteArrayInputStream(obs, 0, size);
                    in = new BufferedInputStream(bis, size);
                    if (this.preparedSaveSql == null) {
                        String saveSql = "INSERT INTO " + this.sessionTable + " (" + this.sessionIdCol + ", " + this.sessionAppCol + ", " + this.sessionDataCol + ", " + this.sessionValidCol + ", " + this.sessionMaxInactiveCol + ", " + this.sessionLastAccessedCol + ") VALUES (?, ?, ?, ?, ?, ?)";
                        this.preparedSaveSql = _conn.prepareStatement(saveSql);
                    }
                    this.preparedSaveSql.setString(1, session.getIdInternal());
                    this.preparedSaveSql.setString(2, this.getName());
                    this.preparedSaveSql.setBinaryStream(3, in, size);
                    this.preparedSaveSql.setString(4, session.isValid() ? "1" : "0");
                    this.preparedSaveSql.setInt(5, session.getMaxInactiveInterval());
                    this.preparedSaveSql.setLong(6, session.getLastAccessedTime());
                    this.preparedSaveSql.execute();
                    numberOfTries = 0;
                    continue;
                }
                catch (SQLException e) {
                    this.manager.getContainer().getLogger().error((Object)this.sm.getString(this.getStoreName() + ".SQLException", (Object)e));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                catch (IOException e) {
                    continue;
                }
                finally {
                    if (oos != null) {
                        oos.close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    this.release(_conn);
                }
            }
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)this.sm.getString(this.getStoreName() + ".saving", (Object)session.getIdInternal(), (Object)this.sessionTable));
        }
    }

    protected Connection getConnection() {
        try {
            if (this.dbConnection == null || this.dbConnection.isClosed()) {
                this.manager.getContainer().getLogger().info((Object)this.sm.getString(this.getStoreName() + ".checkConnectionDBClosed"));
                this.open();
                if (this.dbConnection == null || this.dbConnection.isClosed()) {
                    this.manager.getContainer().getLogger().info((Object)this.sm.getString(this.getStoreName() + ".checkConnectionDBReOpenFail"));
                }
            }
        }
        catch (SQLException ex) {
            this.manager.getContainer().getLogger().error((Object)this.sm.getString(this.getStoreName() + ".checkConnectionSQLException", (Object)ex.toString()));
        }
        return this.dbConnection;
    }

    protected Connection open() throws SQLException {
        if (this.dbConnection != null) {
            return this.dbConnection;
        }
        try {
            if (this.datasource == null) {
                InitialContext ctx = new InitialContext();
                this.datasource = (DataSource)ctx.lookup("java:comp/env/" + this.dataSourceName);
                if (this.datasource != null) {
                    try {
                        this.initTable(this.datasource, this.sessionTable);
                    }
                    catch (SQLException e) {
                        this.manager.getContainer().getLogger().error((Object)"Failed to initialize session table", (Throwable)e);
                    }
                }
            }
            if (this.datasource != null) {
                this.dbConnection = this.datasource.getConnection();
                this.dbConnection.setAutoCommit(true);
                return this.dbConnection;
            }
            this.manager.getContainer().getLogger().error((Object)("Failed to load session datasource: " + this.dataSourceName));
        }
        catch (NamingException e) {
            this.manager.getContainer().getLogger().error((Object)("Failed to load session datasource: " + this.dataSourceName), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            this.preparedSizeSql.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        this.preparedSizeSql = null;
        try {
            this.preparedKeysSql.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        this.preparedKeysSql = null;
        try {
            this.preparedSaveSql.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        this.preparedSaveSql = null;
        try {
            this.preparedClearSql.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        try {
            this.preparedRemoveSql.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        this.preparedRemoveSql = null;
        try {
            this.preparedLoadSql.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        this.preparedLoadSql = null;
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            this.manager.getContainer().getLogger().error((Object)this.sm.getString(this.getStoreName() + ".close", (Object)e.toString()));
        }
        finally {
            this.dbConnection = null;
        }
    }

    protected void release(Connection conn) {
    }

    public void start() throws LifecycleException {
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.dbConnection != null) {
            try {
                this.dbConnection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.close(this.dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTable(DataSource datasource, String tableName) throws SQLException {
        String createQuery = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + "`id` varchar(100) NOT NULL," + "`valid` char(1) NOT NULL," + "`maxinactive` int(11) NOT NULL," + "`lastaccess` bigint(20) default NULL," + "`data` mediumblob," + "`app` varchar(255) default NULL," + "PRIMARY KEY  (`id`)" + ") ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC";
        Connection connection = datasource.getConnection();
        try {
            Statement stmt = connection.createStatement();
            stmt.execute(createQuery);
        }
        finally {
            this.close(connection);
        }
    }
}

