/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.utils;

import com.staxnet.appserver.utils.AutoFlushOutputStream;
import com.staxnet.appserver.utils.MergedOutputStream;
import com.staxnet.appserver.utils.NoCloseInputStream;
import com.staxnet.appserver.utils.NoCloseOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamHelper {
    public static OutputStream createMergedOutputStream(OutputStream out1, OutputStream out2) {
        return new MergedOutputStream(out1, out2);
    }

    public static OutputStream createAutoFlushOutputStream(OutputStream out) {
        return new AutoFlushOutputStream(out);
    }

    public static OutputStream createNoCloseOutputStream(OutputStream out) {
        return new NoCloseOutputStream(out);
    }

    public static InputStream createNoCloseInputStream(InputStream in) {
        return new NoCloseInputStream(in);
    }

    public static void close(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static InputStream copyAndConsumeStream(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamHelper.transferStream(in, bout);
        return new ByteArrayInputStream(bout.toByteArray());
    }

    public static void consumeStream(InputStream in) throws IOException {
        byte[] bytes = new byte[1024];
        int numRead = in.read(bytes);
        while (numRead != -1) {
            numRead = in.read(bytes);
        }
        in.close();
    }

    public static void transferStream(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = new byte[1024];
        int numRead = in.read(bytes);
        while (numRead != -1) {
            out.write(bytes, 0, numRead);
            numRead = in.read(bytes);
        }
    }

    public static byte[] readAll(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamHelper.transferStream(in, bout);
        byte[] bytes = bout.toByteArray();
        bout.close();
        return bytes;
    }
}

