/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.jdbc;

import com.staxnet.jdbc.DataSourceStats;
import com.staxnet.jdbc.ProxyHelper;
import com.staxnet.jdbc.StatementProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

class ConnectionProxy
implements InvocationHandler {
    private static Set<String> closeMethods;
    private static Set<String> statementMethods;
    private static Logger log;
    private Connection target;
    private DataSourceStats mbean;
    private long startTime;

    public ConnectionProxy(DataSourceStats mbean, Connection conn) {
        this.target = conn;
        this.mbean = mbean;
        this.startTime = System.currentTimeMillis();
    }

    public static Object newInstance(DataSourceStats mbean, Connection conn) {
        return Proxy.newProxyInstance(conn.getClass().getClassLoader(), ProxyHelper.getProxyInterfaceList(Connection.class), (InvocationHandler)new ConnectionProxy(mbean, conn));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (closeMethods.contains(method.getName())) {
            this.processClose();
            return method.invoke((Object)this.target, args);
        }
        if (statementMethods.contains(method.getName())) {
            Object value = method.invoke((Object)this.target, args);
            if (value instanceof Statement) {
                return StatementProxy.newInstance(this.mbean, (Statement)value);
            }
            return value;
        }
        return method.invoke((Object)this.target, args);
    }

    private void processClose() {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        this.mbean.incActiveTime(elapsedTime);
        this.mbean.incClose();
    }

    static {
        log = Logger.getLogger(ConnectionProxy.class.getName());
        closeMethods = new HashSet<String>();
        closeMethods.add("close");
        statementMethods = new HashSet<String>();
        statementMethods.add("prepareCall");
        statementMethods.add("prepareStatement");
        statementMethods.add("createStatement");
    }
}

