/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.jdbc;

import com.staxnet.jdbc.DataSourceStatsMBean;
import com.staxnet.jdbc.StaxDataSource;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.tomcat.dbcp.dbcp.BasicDataSource;

public class DataSourceStats
implements DataSourceStatsMBean {
    private static Logger logger = Logger.getLogger(DataSourceStats.class.getName());
    private BasicDataSourceStats basicDSStats;
    private AtomicLong queuedGauge = new AtomicLong();
    private AtomicLong activatedCounter = new AtomicLong();
    private AtomicLong closedCounter = new AtomicLong();
    private AtomicLong getConnWaitTimeCounter = new AtomicLong();
    private AtomicLong activeTimeCounter = new AtomicLong();
    private AtomicLong queryTimeCounter = new AtomicLong();
    private AtomicLong queryErrorCounter = new AtomicLong();
    private AtomicLong queryCounter = new AtomicLong();
    private AtomicLong slowQuery1SecCounter = new AtomicLong();
    private AtomicLong slowQuery10SecCounter = new AtomicLong();
    private AtomicLong slowQuery1MinCounter = new AtomicLong();

    DataSourceStats(DataSource ds) {
        this.basicDSStats = ds instanceof BasicDataSource ? new BasicDataSourceStatsImpl((BasicDataSource)ds) : (ds instanceof StaxDataSource ? new StaxDataSourceStatsImpl((StaxDataSource)ds) : new NilDataSourceStatsImpl());
    }

    @Override
    public long getUsedConnections() {
        return this.activatedCounter.get();
    }

    @Override
    public long getQueuedTime() {
        return this.getConnWaitTimeCounter.get();
    }

    @Override
    public long getQueueSize() {
        return this.queuedGauge.get();
    }

    @Override
    public long getActiveTime() {
        return this.activeTimeCounter.get();
    }

    @Override
    public long getActiveConnections() {
        return this.basicDSStats.getNumActive();
    }

    @Override
    public long getIdleConnections() {
        return this.basicDSStats.getNumIdle();
    }

    @Override
    public long getOpenDBConnections() {
        return this.getActiveConnections() + this.getIdleConnections();
    }

    @Override
    public long getAvailConnections() {
        int max = this.basicDSStats.getMaxActive();
        int numActive = this.basicDSStats.getNumActive();
        if (max >= 0 && numActive >= 0) {
            return max - numActive;
        }
        return -1L;
    }

    @Override
    public long getQueryCount() {
        return this.queryCounter.get();
    }

    @Override
    public long getQueryErrors() {
        return this.queryErrorCounter.get();
    }

    @Override
    public long getQueryTime() {
        return this.queryTimeCounter.get();
    }

    @Override
    public long getSlowQuery10sec() {
        return this.slowQuery10SecCounter.get();
    }

    @Override
    public long getSlowQuery1min() {
        return this.slowQuery1MinCounter.get();
    }

    @Override
    public long getSlowQuery1sec() {
        return this.slowQuery1SecCounter.get();
    }

    @Override
    public long getClosedConnections() {
        return this.closedCounter.get();
    }

    @Override
    public long getUnclosedConnections() {
        return this.getUsedConnections() - this.getClosedConnections();
    }

    public void incClose() {
        this.closedCounter.incrementAndGet();
    }

    public void incGettingConnection() {
        this.queuedGauge.incrementAndGet();
    }

    public void gotConnection(long waitTime) {
        this.queuedGauge.decrementAndGet();
        this.activatedCounter.incrementAndGet();
        this.getConnWaitTimeCounter.addAndGet(waitTime);
    }

    public void incActiveTime(long elapsed) {
        this.activeTimeCounter.addAndGet(elapsed);
    }

    public void statementExecuted(long elapsed, boolean error) {
        this.queryTimeCounter.addAndGet(elapsed);
        this.queryCounter.incrementAndGet();
        if (error) {
            this.queryErrorCounter.incrementAndGet();
        }
        if (elapsed >= 1000L) {
            this.slowQuery1SecCounter.incrementAndGet();
        }
        if (elapsed >= 10000L) {
            this.slowQuery10SecCounter.incrementAndGet();
        }
        if (elapsed >= 60000L) {
            this.slowQuery1MinCounter.incrementAndGet();
        }
    }

    class NilDataSourceStatsImpl
    implements BasicDataSourceStats {
        @Override
        public int getNumActive() {
            return -1;
        }

        @Override
        public int getNumIdle() {
            return -1;
        }

        @Override
        public int getMaxActive() {
            return -1;
        }
    }

    class StaxDataSourceStatsImpl
    implements BasicDataSourceStats {
        private StaxDataSource ds;

        public StaxDataSourceStatsImpl(StaxDataSource ds) {
            this.ds = ds;
        }

        @Override
        public int getNumActive() {
            return this.ds.getNumActive();
        }

        @Override
        public int getNumIdle() {
            return this.ds.getNumIdle();
        }

        @Override
        public int getMaxActive() {
            return this.ds.getMaxActive();
        }
    }

    class BasicDataSourceStatsImpl
    implements BasicDataSourceStats {
        private BasicDataSource ds;

        public BasicDataSourceStatsImpl(BasicDataSource ds) {
            this.ds = ds;
        }

        @Override
        public int getNumActive() {
            return this.ds.getNumActive();
        }

        @Override
        public int getNumIdle() {
            return this.ds.getNumIdle();
        }

        @Override
        public int getMaxActive() {
            return this.ds.getMaxActive();
        }
    }

    static interface BasicDataSourceStats {
        public int getNumIdle();

        public int getNumActive();

        public int getMaxActive();
    }
}

