/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.jdbc;

import com.staxnet.jdbc.DatabaseConnectInfo;
import com.staxnet.jdbc.GetDatabaseConnectInfoListResult;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Driver
implements java.sql.Driver {
    private static Map<String, String> dburlTable = new HashMap<String, String>();
    private static java.sql.Driver mysqlDriver = null;
    private static java.sql.Driver mysqlReplicationDriver = null;
    private static String JDBC_URL_PREFIX = "jdbc:cloudbees://";
    private static String JDBC_URL_PREFIX_OLD = "jdbc:stax://";
    public static String getDatabaseConnectInfoBaseURL;
    private static String getDatabaseConnectInfoURLFormat;

    private static java.sql.Driver loadMySQLDriver() {
        if (mysqlDriver == null) {
            String mysqlDriverClassName = "com.mysql.jdbc.Driver";
            try {
                mysqlDriver = (java.sql.Driver)Class.forName(mysqlDriverClassName).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mysqlDriver;
    }

    private static java.sql.Driver loadMySQLReplicationDriver() {
        if (mysqlReplicationDriver == null) {
            String mysqlDriverClassName = "com.mysql.jdbc.ReplicationDriver";
            try {
                mysqlReplicationDriver = (java.sql.Driver)Class.forName(mysqlDriverClassName).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mysqlReplicationDriver;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(JDBC_URL_PREFIX) || url.startsWith(JDBC_URL_PREFIX_OLD);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        int startIndex = url.indexOf("://") + 3;
        int endIndex = Math.min(url.indexOf(47, startIndex + 1), url.indexOf(63, startIndex + 1));
        endIndex = endIndex != -1 ? endIndex : url.length();
        String dbName = url.substring(startIndex, endIndex);
        return this.getMySqlConnection(dbName, info);
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[]{this.createDriverProperty("user", null), this.createDriverProperty("password", null)};
    }

    private DriverPropertyInfo createDriverProperty(String name, String defaultValue) {
        return new DriverPropertyInfo(name, defaultValue);
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private Connection getMySqlConnection(String dbName, Properties info) throws SQLException {
        String dbURL = this.getDatabaseURL(dbName, false);
        Connection conn = null;
        try {
            conn = this.createConnection(dbName, info, dbURL);
        }
        catch (Exception e) {
            dbURL = this.getDatabaseURL(dbName, true);
            conn = this.createConnection(dbName, info, dbURL);
        }
        return conn;
    }

    private Connection createConnection(String dbName, Properties info, String dbURL) throws SQLException {
        java.sql.Driver driver;
        String useReplicationMode;
        int queryIndex = dbName.indexOf(63);
        if (queryIndex > -1) {
            if (dbName.length() > queryIndex + 1) {
                String[] nvPairs;
                String queryString = dbName.substring(queryIndex + 1);
                for (String nvPair : nvPairs = queryString.split("&")) {
                    String[] pair = nvPair.split("=");
                    if (pair.length <= 1) continue;
                    info.put(pair[0], pair[1]);
                }
            }
            dbName = dbName.substring(0, queryIndex);
        }
        if ((useReplicationMode = info.getProperty("useReplicationMode")) != null && useReplicationMode.equals("true")) {
            driver = Driver.loadMySQLReplicationDriver();
            this.setDefaultProperty("autoReconnect", "true", info);
            this.setDefaultProperty("roundRobinLoadBalance", "true", info);
        } else {
            driver = Driver.loadMySQLDriver();
            this.setDefaultProperty("autoReconnect", "true", info);
        }
        Connection conn = driver.connect(dbURL, info);
        return conn;
    }

    private void setDefaultProperty(String name, String defaultValue, Properties props) {
        if (!props.containsKey(name)) {
            props.put(name, defaultValue);
        }
    }

    private String getDatabaseURL(String dbName, boolean refreshCache) throws SQLException {
        String dbURL = dburlTable.get(dbName);
        if (refreshCache || dbURL == null) {
            List<DatabaseConnectInfo> connectionInfo = this.getConnectionInfoList(dbName);
            String url = this.createDriverUrl(dbName, connectionInfo);
            dburlTable.put(dbName, url);
            dbURL = url;
        }
        return dbURL;
    }

    private String createDriverUrl(String databaseName, List<DatabaseConnectInfo> connInfos) {
        ArrayList<DatabaseConnectInfo> slaveInfos = new ArrayList<DatabaseConnectInfo>();
        ArrayList<DatabaseConnectInfo> masterInfos = new ArrayList<DatabaseConnectInfo>();
        for (DatabaseConnectInfo connectInfo : connInfos) {
            String type = connectInfo.getType();
            if (type == null || type.equals("master")) {
                masterInfos.add(connectInfo);
                continue;
            }
            if (!type.equals("slave")) continue;
            slaveInfos.add(connectInfo);
        }
        StringBuilder sb = new StringBuilder();
        for (DatabaseConnectInfo info : masterInfos) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(info.getAddress());
            sb.append(":");
            sb.append(info.getPort());
        }
        for (DatabaseConnectInfo info : slaveInfos) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(info.getAddress());
            sb.append(":");
            sb.append(info.getPort());
        }
        sb.append("/");
        sb.append(databaseName);
        return "jdbc:mysql://" + sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DatabaseConnectInfo> getConnectionInfoList(String dbName) throws SQLException {
        String apiUrl = String.format(getDatabaseConnectInfoURLFormat, getDatabaseConnectInfoBaseURL, dbName);
        try {
            URL url = new URL(apiUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection.getResponseCode() != 200) {
                if (connection.getResponseCode() != 500) throw new SQLException("Error getting database connection info (status=" + connection.getResponseCode() + ", message=" + connection.getResponseMessage() + ")");
                throw new SQLException("cannot access Stax database: " + dbName);
            }
            InputStream in = connection.getInputStream();
            try {
                XStream xstream = new XStream();
                xstream.alias("getDatabaseConnectInfoListResult", GetDatabaseConnectInfoListResult.class);
                xstream.addImplicitCollection(GetDatabaseConnectInfoListResult.class, "infos");
                xstream.alias("databaseConnectInfo", DatabaseConnectInfo.class);
                Object result = xstream.fromXML(in);
                if (!(result instanceof GetDatabaseConnectInfoListResult)) throw new SQLException("unexpected result detected: " + result.getClass().getName());
                List<DatabaseConnectInfo> list = ((GetDatabaseConnectInfoListResult)result).getInfos();
                return list;
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException("Error getting connection info");
        }
    }

    static {
        Driver driverInst = new Driver();
        try {
            DriverManager.registerDriver(driverInst);
            Driver.loadMySQLDriver();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        getDatabaseConnectInfoBaseURL = "http://api.stax.net/";
        getDatabaseConnectInfoURLFormat = "%sapi/db/getDatabaseConnectInfoList/%s";
    }
}

