/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.jdbc;

import com.staxnet.jdbc.ConnectionProxy;
import com.staxnet.jdbc.DataSourceStats;
import com.staxnet.jdbc.InvocationHooks;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;

public class ManagedDataSource
implements DataSource {
    private static Logger log = Logger.getLogger(ManagedDataSource.class.getName());
    private DataSource ds;
    private DataSourceStats mbean;

    ManagedDataSource(DataSource impl, DataSourceStats mbean) {
        this.ds = impl;
        this.mbean = mbean;
    }

    public static DataSource wrapAndRegister(String dsName, DataSource impl) {
        String mbeanName = "net.stax:type=DataSource,name=\"" + dsName + "\"";
        try {
            DataSourceStats mbean = new DataSourceStats(impl);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(mbeanName);
            try {
                mbs.unregisterMBean(objectName);
            }
            catch (Exception e) {
                // empty catch block
            }
            mbs.registerMBean(mbean, objectName);
            return new ManagedDataSource(impl, mbean);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "failed to load mbean: " + mbeanName, e);
            return impl;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.invoke(new GetConnectionInvocationBase(){

                @Override
                public Connection invoke() throws Exception {
                    return (Connection)ConnectionProxy.newInstance(ManagedDataSource.this.mbean, ManagedDataSource.this.ds.getConnection());
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            this.rethrowIf(SQLException.class, cause);
            throw this.throwRuntimeException(cause);
        }
        catch (Throwable e) {
            throw this.throwRuntimeException(e);
        }
    }

    @Override
    public Connection getConnection(final String username, final String password) throws SQLException {
        try {
            return this.invoke(new GetConnectionInvocationBase(){

                @Override
                public Connection invoke() throws Exception {
                    return (Connection)ConnectionProxy.newInstance(ManagedDataSource.this.mbean, ManagedDataSource.this.ds.getConnection(username, password));
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            this.rethrowIf(SQLException.class, cause);
            throw this.throwRuntimeException(cause);
        }
    }

    private <T extends Throwable> void rethrowIf(Class<T> cls, Throwable th) throws T {
        if (cls.isInstance(th)) {
            throw th;
        }
    }

    private RuntimeException throwRuntimeException(Throwable th) {
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof Error) {
            throw (Error)th;
        }
        throw new RuntimeException(th);
    }

    private <T> T invoke(InvocationHooks<T> hooks) throws InvocationTargetException {
        try {
            T t;
            hooks.onBefore();
            try {
                t = hooks.invoke();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error in proxy invoke", e);
                throw new InvocationTargetException(e);
            }
            return t;
        }
        finally {
            hooks.onAfter();
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.ds.getLogWriter();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.ds.isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.ds.setLogWriter(out);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.ds.unwrap(iface);
    }

    abstract class GetConnectionInvocationBase
    implements InvocationHooks<Connection> {
        long queueStartTime;

        GetConnectionInvocationBase() {
        }

        @Override
        public synchronized void onBefore() {
            this.queueStartTime = System.currentTimeMillis();
            ManagedDataSource.this.mbean.incGettingConnection();
        }

        @Override
        public synchronized void onAfter() {
            ManagedDataSource.this.mbean.gotConnection(System.currentTimeMillis() - this.queueStartTime);
            this.queueStartTime = -1L;
        }
    }
}

