/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.jdbc;

import com.staxnet.jdbc.ConnectionProxy;
import com.staxnet.jdbc.DataSourceStats;
import com.staxnet.jdbc.ProxyHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

class StatementProxy
implements InvocationHandler {
    private static Set<String> executeMethods;
    private static Set<String> getConnectionMethods;
    private static Logger log;
    private Statement target;
    private DataSourceStats mbean;

    private StatementProxy(DataSourceStats mbean, Statement stmt) {
        this.target = stmt;
        this.mbean = mbean;
    }

    public static Object newInstance(DataSourceStats mbean, Statement stmt) {
        return Proxy.newProxyInstance(stmt.getClass().getClassLoader(), ProxyHelper.getProxyInterfaceList(CallableStatement.class), (InvocationHandler)new StatementProxy(mbean, stmt));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (executeMethods.contains(method.getName())) {
            return this.processExecute(proxy, method, args);
        }
        if (getConnectionMethods.contains(method.getName())) {
            Object result = method.invoke((Object)this.target, args);
            if (result instanceof Connection) {
                return ConnectionProxy.newInstance(this.mbean, (Connection)result);
            }
            return result;
        }
        return method.invoke((Object)this.target, args);
    }

    private Object processExecute(Object proxy, Method method, Object[] args) throws Throwable {
        long start = System.currentTimeMillis();
        boolean error = false;
        try {
            Object object = method.invoke((Object)this.target, args);
            return object;
        }
        catch (Throwable th) {
            error = true;
            throw th;
        }
        finally {
            long elapsed = System.currentTimeMillis() - start;
            this.mbean.statementExecuted(elapsed, error);
        }
    }

    static {
        log = Logger.getLogger(StatementProxy.class.getName());
        executeMethods = new HashSet<String>();
        executeMethods.add("execute");
        executeMethods.add("executeBatch");
        executeMethods.add("executeQuery");
        executeMethods.add("executeUpdate");
        getConnectionMethods = new HashSet<String>();
        getConnectionMethods.add("getConnection");
    }
}

