/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.jdbc;

import com.staxnet.jdbc.DataSourceFactory;
import com.staxnet.jdbc.DataSourceValidator;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.sql.DataSource;
import org.apache.tomcat.dbcp.dbcp.BasicDataSource;

class StaxDataSource
implements DataSource {
    static Logger logger = Logger.getLogger("stax.jdbc");
    private static long DATASOURCE_TIMEOUT = 1800000L;
    private static long DATASOURCE_IDLE_TIMEOUT = 300000L;
    private BasicDataSource dataSource;
    private DataSourceValidator validator;
    private DataSourceFactory dataSourceFactory;
    private Name name;
    private long activeStartTime = -1L;
    private Level DEBUG = Level.FINE;
    private static Map<String, Method> java6Methods = new HashMap<String, Method>();

    public StaxDataSource(Name name, DataSourceFactory dataSourceFactory, DataSourceValidator validator) throws Exception {
        this.name = name;
        this.dataSourceFactory = dataSourceFactory;
        this.validator = validator;
        this.resetDataSource();
    }

    private synchronized void resetDataSource() throws Exception {
        if (this.dataSource != null) {
            logger.log(this.DEBUG, "Reloading datasource: " + this.name.toString());
            this.closeDatasourceWhenIdle(this.dataSource, DATASOURCE_IDLE_TIMEOUT, 1000L);
        }
        this.dataSource = this.dataSourceFactory.createDataSource();
        this.activeStartTime = -1L;
    }

    private void closeDatasourceWhenIdle(final BasicDataSource dataSource, final long timeoutMillis, final long checkIntervalMillis) {
        Thread th = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block14: {
                    long startTime = System.currentTimeMillis();
                    while (System.currentTimeMillis() - startTime < timeoutMillis && dataSource.getNumActive() > 0) {
                        logger.log(Level.FINER, String.format("waiting for datasource active connections to close [activeCount=%d, name=%s", dataSource.getNumActive(), StaxDataSource.this.name.toString()));
                        Thread.sleep(checkIntervalMillis);
                    }
                    if (dataSource.getNumActive() > 0) {
                        logger.log(Level.WARNING, String.format("forcing connections closed [activeCount=%d, name=%s", dataSource.getNumActive(), StaxDataSource.this.name.toString()));
                    }
                    try {
                        dataSource.close();
                        logger.log(StaxDataSource.this.DEBUG, "datasource closed: " + StaxDataSource.this.name.toString());
                    }
                    catch (SQLException e) {
                        logger.log(Level.WARNING, "failed to close datasource: " + StaxDataSource.this.name.toString(), e);
                    }
                    break block14;
                    catch (Exception e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            if (dataSource.getNumActive() > 0) {
                                logger.log(Level.WARNING, String.format("forcing connections closed [activeCount=%d, name=%s", dataSource.getNumActive(), StaxDataSource.this.name.toString()));
                            }
                            try {
                                dataSource.close();
                                logger.log(StaxDataSource.this.DEBUG, "datasource closed: " + StaxDataSource.this.name.toString());
                            }
                            catch (SQLException e2) {
                                logger.log(Level.WARNING, "failed to close datasource: " + StaxDataSource.this.name.toString(), e2);
                            }
                            throw throwable;
                        }
                        if (dataSource.getNumActive() > 0) {
                            logger.log(Level.WARNING, String.format("forcing connections closed [activeCount=%d, name=%s", dataSource.getNumActive(), StaxDataSource.this.name.toString()));
                        }
                        try {
                            dataSource.close();
                            logger.log(StaxDataSource.this.DEBUG, "datasource closed: " + StaxDataSource.this.name.toString());
                        }
                        catch (SQLException e3) {
                            logger.log(Level.WARNING, "failed to close datasource: " + StaxDataSource.this.name.toString(), e3);
                        }
                    }
                }
            }
        });
        th.setDaemon(true);
        th.start();
    }

    public int getNumIdle() {
        return this.dataSource.getNumIdle();
    }

    public int getNumActive() {
        return this.dataSource.getNumActive();
    }

    public int getMaxActive() {
        return this.dataSource.getMaxActive();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.activeStartTime < 0L) {
            this.activeStartTime = System.currentTimeMillis();
        }
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.activeStartTime < 0L) {
            this.activeStartTime = System.currentTimeMillis();
        }
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return (Boolean)this.invoke("isWrapperFor", Class.class);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.invoke("unwrap", Class.class);
    }

    private BasicDataSource getRawDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBackgroundWork() {
        try {
            this.validateDataSource();
            StaxDataSource staxDataSource = this;
            synchronized (staxDataSource) {
                long activeTime;
                if (this.dataSource.getNumActive() + this.dataSource.getNumIdle() == 0) {
                    this.activeStartTime = -1L;
                }
                if (this.activeStartTime > 0L && (activeTime = System.currentTimeMillis() - this.activeStartTime) > DATASOURCE_TIMEOUT) {
                    this.resetDataSource();
                }
            }
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "error doing backaground task", th);
        }
    }

    private void validateDataSource() {
        int currentConnectionCount = this.dataSource.getNumActive() + this.dataSource.getNumIdle();
        if (this.activeStartTime > 0L && currentConnectionCount > 0 && this.validator != null && !this.validator.validate(this)) {
            try {
                this.resetDataSource();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "failed to reset datasource: " + this.name.toString(), e);
            }
        }
    }

    private Object invoke(String methodName, Class ... args) throws SQLException {
        try {
            Method m = java6Methods.get(methodName);
            if (m == null) {
                m = this.dataSource.getClass().getMethod(methodName, args);
                if (m != null) {
                    java6Methods.put(methodName, m);
                } else {
                    throw new SQLException("unsupported method: " + methodName);
                }
            }
            return m.invoke((Object)this.dataSource, (Object[])args);
        }
        catch (SecurityException e) {
            throw new SQLException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new SQLException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public String toString() {
        return this.name.toString();
    }
}

