/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.jdbc;

import com.staxnet.jdbc.DataSourceFactory;
import com.staxnet.jdbc.DataSourceValidator;
import com.staxnet.jdbc.QueryBasedValidator;
import com.staxnet.jdbc.StaxDataSource;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.tomcat.dbcp.dbcp.BasicDataSource;
import org.apache.tomcat.dbcp.dbcp.BasicDataSourceFactory;

public class StaxDataSourceFactory
implements ObjectFactory {
    public static final String DATA_SOURCE_NAME = "reference.name";
    private BasicDataSourceFactory dbcpFactory = new BasicDataSourceFactory();
    private static DatabaseStatusPoller poller;

    public Object getObjectInstance(final Object obj, final Name name, final Context context, final Hashtable environment) throws Exception {
        Reference ref = (Reference)obj;
        DataSourceFactory factory = new DataSourceFactory(){

            @Override
            public BasicDataSource createDataSource() throws Exception {
                BasicDataSource dataSource = (BasicDataSource)StaxDataSourceFactory.this.dbcpFactory.getObjectInstance(obj, name, context, environment);
                return dataSource;
            }
        };
        String dsName = (String)ref.get(DATA_SOURCE_NAME).getContent();
        DataSourceValidator validator = this.getDataSourceValidator(ref);
        if (validator != null) {
            StaxDataSource staxDS = new StaxDataSource(name, factory, validator);
            this.getPoller().addDataSource(staxDS);
            return staxDS;
        }
        return factory.createDataSource();
    }

    private DatabaseStatusPoller getPoller() {
        if (poller == null) {
            poller = new DatabaseStatusPoller();
            Thread th = new Thread((Runnable)poller, "jdbc-monitor");
            th.setDaemon(true);
            th.start();
        }
        return poller;
    }

    private String getRefValue(Reference ref, String name) {
        RefAddr ra = ref.get(name);
        if (ra != null) {
            return ra.getContent().toString();
        }
        return null;
    }

    private DataSourceValidator getDataSourceValidator(Reference ref) {
        String url = this.getRefValue(ref, "url");
        if (url != null && url.startsWith("jdbc:stax://")) {
            String validationQuery = this.getRefValue(ref, "validationQuery");
            if (validationQuery == null) {
                int startIndex = "jdbc:stax://".length();
                int lastIndex = url.indexOf(63);
                if (lastIndex == -1) {
                    lastIndex = url.length();
                }
                String dbName = url.substring(startIndex, lastIndex);
                validationQuery = "show table status from `" + dbName + "`";
            }
            return new QueryBasedValidator(validationQuery);
        }
        return null;
    }

    class DatabaseStatusPoller
    implements Runnable {
        private Logger logger = Logger.getLogger("stax.jdbc");
        private static final int POLL_SECONDS = 60;
        boolean stopped;
        private List<StaxDataSource> datasources = new ArrayList<StaxDataSource>();

        DatabaseStatusPoller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDataSource(StaxDataSource ds) {
            DatabaseStatusPoller databaseStatusPoller = this;
            synchronized (databaseStatusPoller) {
                this.datasources.add(ds);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (this.stopped) continue;
                DatabaseStatusPoller databaseStatusPoller = this;
                synchronized (databaseStatusPoller) {
                    for (StaxDataSource ds : this.datasources) {
                        try {
                            ds.doBackgroundWork();
                        }
                        catch (Exception e) {
                            this.logger.log(Level.INFO, "Error validating datasource: " + ds, e);
                        }
                    }
                }
            }
        }
    }
}

