/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.utils;

import com.staxnet.utils.FileInputHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFile(File f, FileInputHandler fih) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        try {
            fih.read(fin);
        }
        finally {
            fin.close();
        }
    }

    public static void deleteAll(File dir) {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                for (File f : dir.listFiles()) {
                    if (f.isDirectory()) {
                        FileHelper.deleteAll(f);
                        continue;
                    }
                    f.delete();
                }
            }
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAll(File from, File to) throws IOException {
        for (File f : from.listFiles()) {
            if (f.isDirectory()) {
                if (f.isHidden()) continue;
                File newTo = new File(to, f.getName());
                newTo.mkdir();
                FileHelper.copyAll(f, newTo);
                continue;
            }
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(f);
            try {
                FileOutputStream out = new FileOutputStream(new File(to, f.getName()));
                try {
                    int numRead = in.read(buf);
                    while (numRead != -1) {
                        out.write(buf, 0, numRead);
                        numRead = in.read(buf);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
    }
}

