/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin;

import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.IEngineFactory;
import java.net.InetAddress;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.stax.appserver.admin.StaxApplicationQueryValve;
import net.stax.appserver.admin.jmx.JMXValve;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Embedded;

public class AdminEngine
implements IEngineFactory {
    protected static Logger logger = Logger.getLogger(AdminEngine.class.getName());
    private IAppServerConfiguration appServerConfig;
    private int port;
    private int webappPort;
    private Timer timer = new Timer();

    public AdminEngine(IAppServerConfiguration appServerConfig, int adminPort, int webappPort) {
        this.appServerConfig = appServerConfig;
        this.port = adminPort;
        this.webappPort = webappPort;
    }

    @Override
    public Engine createEngine(Embedded container) throws Exception {
        Engine engine = container.createEngine();
        engine.setName("adminEngine");
        Host host = container.createHost("localhost", null);
        engine.addChild((Container)host);
        engine.setDefaultHost(host.getName());
        container.addEngine(engine);
        if (this.appServerConfig.getServerCallbackUrl() != null) {
            engine.getPipeline().addValve((Valve)new StaxApplicationQueryValve(this.appServerConfig, this.webappPort, this.timer));
        }
        engine.getPipeline().addValve((Valve)new JMXValve(this.appServerConfig.getServerCallbackAuthToken()));
        Connector adminConnector = this.createAdminHttpConnector(container);
        container.addConnector(adminConnector);
        return engine;
    }

    private Connector createAdminHttpConnector(Embedded container) {
        String protocol = "org.apache.coyote.http11.Http11Protocol";
        logger.log(Level.INFO, String.format("Initializing admin-http-connector protocol: %s", protocol));
        Connector httpConnector = container.createConnector((InetAddress)null, this.port, protocol);
        httpConnector.setURIEncoding("UTF-8");
        return httpConnector;
    }
}

