/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.ServletException;
import net.stax.appserver.admin.AppStat;
import net.stax.appserver.admin.AppStatsResult;
import net.stax.appserver.admin.MBeanHelper;
import net.stax.appserver.admin.MBeanIntervalCounter;
import net.stax.appserver.admin.QueryHandler;
import net.stax.appserver.admin.RateCounter;
import net.stax.appserver.admin.RequestProcessingTimeCounter;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.mbeans.MBeanUtils;

public class AppStatsQuery
extends QueryHandler {
    private static Logger logger = Logger.getLogger(AppStatsQuery.class.getName());
    private int serverPort;
    private Timer timer;
    private List<RateCounter> rateCounters = new ArrayList<RateCounter>();
    String MANAGER_MBEAN = "localEngine:host=localhost,path=/,type=Manager";
    String REQUEST_PROCESSOR;

    public AppStatsQuery(int serverPort, Timer timer) {
        this.serverPort = serverPort;
        this.timer = timer;
        this.REQUEST_PROCESSOR = String.format("localEngine:name=http-%d,type=GlobalRequestProcessor", serverPort);
        MBeanIntervalCounter requestCounter = new MBeanIntervalCounter("request.requestCount", this.REQUEST_PROCESSOR, "requestCount");
        this.rateCounters.add(requestCounter);
        this.rateCounters.add(new MBeanIntervalCounter("request.errorCount", this.REQUEST_PROCESSOR, "errorCount"));
        this.rateCounters.add(new MBeanIntervalCounter("request.bytesReceived", this.REQUEST_PROCESSOR, "bytesReceived"));
        this.rateCounters.add(new MBeanIntervalCounter("request.bytesSent", this.REQUEST_PROCESSOR, "bytesSent"));
        this.rateCounters.add(new RequestProcessingTimeCounter("request.processingTime", this.REQUEST_PROCESSOR, "processingTime", requestCounter));
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (RateCounter counter : AppStatsQuery.this.rateCounters) {
                    counter.updateValue();
                }
            }
        }, 60000L, 60000L);
    }

    @Override
    public void handleQuery(Request request, Response response) throws IOException, ServletException {
        String format;
        AppStatsResult result = new AppStatsResult();
        this.collectRateStats(result);
        this.collectMemoryStats(result);
        this.collectThreadStats(result);
        this.collectClassLoadingStats(result);
        this.collectTomcatStats(result, request);
        String showAll = request.getParameter("showAll");
        if (showAll != null && showAll.equalsIgnoreCase("true")) {
            this.loadTomcatStats(MBeanUtils.createServer(), result);
        }
        if ("properties".equals(format = request.getParameter("format"))) {
            this.writePropertiesResponse(request, response, result);
        } else {
            this.writeXMLResponse(request, response, result);
        }
    }

    private void writePropertiesResponse(Request request, Response response, AppStatsResult result) throws IOException {
        response.setContentType("text/plain");
        Properties properties = new Properties();
        for (AppStat stat : result.stats) {
            properties.setProperty(stat.name, new Double(stat.value).toString());
        }
        properties.store((OutputStream)response.getOutputStream(), "");
    }

    @Override
    protected void configureXStream(XStream xstream) {
        xstream.processAnnotations(AppStatsResult.class);
    }

    private void collectRateStats(AppStatsResult stats) {
        for (RateCounter counter : this.rateCounters) {
            stats.add(counter.getCounterName(), counter.getValue());
        }
    }

    private void collectThreadStats(AppStatsResult stats) {
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        stats.add("threads.count", tb.getThreadCount());
        stats.add("threads.peakCount", tb.getPeakThreadCount());
        long[] threadIds = tb.getAllThreadIds();
        long cpuTime = 0L;
        for (long threadId : threadIds) {
            cpuTime += tb.getThreadCpuTime(threadId);
        }
        stats.add("threads.cputime", cpuTime / 1000000L);
    }

    private void collectClassLoadingStats(AppStatsResult stats) {
        ClassLoadingMXBean clb = ManagementFactory.getClassLoadingMXBean();
        stats.add("classes.loaded", clb.getLoadedClassCount());
    }

    private void collectMemoryStats(AppStatsResult stats) {
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        stats.add("memory.heap.committed", memoryUsage.getCommitted());
        stats.add("memory.heap.max", memoryUsage.getMax());
        stats.add("memory.heap.used", memoryUsage.getUsed());
        memoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        stats.add("memory.nonheap.committed", memoryUsage.getCommitted());
        stats.add("memory.nonheap.max", memoryUsage.getMax());
        stats.add("memory.nonheap.used", memoryUsage.getUsed());
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean pool : pools) {
            MemoryUsage peak = pool.getPeakUsage();
            String name = pool.getName().replace(' ', '_').toLowerCase();
            String statNameBase = "memory." + name;
            MemoryUsage usage = pool.getUsage();
            stats.add(statNameBase + ".used", usage.getUsed());
            stats.add(statNameBase + ".committed", usage.getCommitted());
            stats.add(statNameBase + ".peakUsed", peak.getUsed());
            stats.add(statNameBase + ".peakCommitted", peak.getCommitted());
        }
    }

    private void collectThreadInfoStats(AppStatsResult stats) {
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        long[] threadIds = tb.getAllThreadIds();
        long blockedThreads = 0L;
        long waitingThreads = 0L;
        for (long threadId : threadIds) {
            ThreadInfo info = tb.getThreadInfo(threadId);
            if (info.getThreadState() == Thread.State.BLOCKED) {
                ++blockedThreads;
            }
            if (info.getThreadState() != Thread.State.TIMED_WAITING) continue;
            ++waitingThreads;
        }
        stats.add("threads.blocked", blockedThreads);
        stats.add("threads.waiting", waitingThreads);
    }

    private void collectTomcatStats(AppStatsResult stats, Request request) {
        MBeanServer server = MBeanHelper.findMBeanServerByMBeanName(this.MANAGER_MBEAN);
        this.addMBeanStat(stats, server, this.MANAGER_MBEAN, "activeSessions", "application.activeSessions");
        this.addMBeanStat(stats, server, this.MANAGER_MBEAN, "expiredSessions", "application.expiredSessions");
    }

    private void addMBeanStat(AppStatsResult stats, MBeanServer server, String objectName, String attribute, String statName) {
        try {
            ObjectName name = new ObjectName(objectName);
            Object objectValue = server.getAttribute(name, attribute);
            if (objectValue != null) {
                if (objectValue instanceof Long) {
                    stats.add(statName, ((Long)objectValue).longValue());
                } else if (objectValue instanceof Integer) {
                    stats.add(statName, ((Integer)objectValue).intValue());
                }
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (MBeanException e) {
            e.printStackTrace();
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
    }

    protected Map preloadObjectNames(MBeanServer server) {
        TreeMap objectNames = new TreeMap();
        try {
            Set<ObjectName> ons = server.queryNames(null, null);
            for (ObjectName name : ons) {
                List<ObjectName> l;
                String domain = name.getDomain();
                Map typeNames = null;
                if (objectNames.containsKey(domain)) {
                    typeNames = (Map)objectNames.get(domain);
                } else {
                    typeNames = new TreeMap();
                    objectNames.put(domain, typeNames);
                }
                String typeName = name.getKeyProperty("type");
                if (typeName == null) {
                    typeName = name.getKeyProperty("Type");
                }
                if (typeName == null) {
                    typeName = "none";
                }
                if (typeNames.containsKey(typeName)) {
                    l = (List)typeNames.get(typeName);
                    l.add(name);
                    continue;
                }
                l = new ArrayList();
                l.add(name);
                typeNames.put(typeName, l);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectNames;
    }

    private void loadTomcatStats(MBeanServer server, AppStatsResult stats) {
        Map objectNames = this.preloadObjectNames(server);
        for (String key : objectNames.keySet()) {
            Map typeNames = (Map)objectNames.get(key);
            for (String typeName : typeNames.keySet()) {
                List beans = (List)typeNames.get(typeName);
                Iterator k = beans.iterator();
                while (k.hasNext()) {
                    try {
                        ObjectName on = (ObjectName)k.next();
                        MBeanInfo info = server.getMBeanInfo(on);
                        MBeanAttributeInfo[] attributeArray = info.getAttributes();
                        for (int x = 0; x < attributeArray.length; ++x) {
                            try {
                                String attributeName = attributeArray[x].getName();
                                Object objectValue = server.getAttribute(on, attributeName);
                                if (objectValue == null) continue;
                                if (objectValue instanceof Long) {
                                    stats.add(on.getCanonicalName() + "." + attributeName, ((Long)objectValue).longValue());
                                    continue;
                                }
                                if (!(objectValue instanceof Integer)) continue;
                                stats.add(on.getCanonicalName() + "." + attributeName, ((Integer)objectValue).intValue());
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception e) {
                    }
                }
            }
        }
    }
}

