/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.stax.appserver.admin.MBeanHelper;
import net.stax.appserver.admin.RateCounter;

public class MBeanIntervalCounter
implements RateCounter {
    private String counterName;
    private String objectName;
    private String attribute;
    private MBeanServer server;
    protected double lastTotalValue;
    protected double currentValue;

    public MBeanIntervalCounter(String counterName, String objectName, String attribute) {
        this.counterName = counterName;
        this.objectName = objectName;
        this.attribute = attribute;
    }

    @Override
    public String getCounterName() {
        return this.counterName;
    }

    @Override
    public void updateValue() {
        double newTotalValue = this.getMBeanStat();
        double diff = newTotalValue - this.lastTotalValue;
        this.lastTotalValue = newTotalValue;
        this.currentValue = diff;
    }

    @Override
    public double getValue() {
        return this.currentValue;
    }

    private MBeanServer getServer() {
        if (this.server == null) {
            this.server = MBeanHelper.findMBeanServerByMBeanName(this.objectName);
        }
        return this.server;
    }

    protected double getMBeanStat() {
        try {
            MBeanServer server = this.getServer();
            if (server == null) {
                return 0.0;
            }
            ObjectName name = new ObjectName(this.objectName);
            Object objectValue = server.getAttribute(name, this.attribute);
            if (objectValue != null) {
                if (objectValue instanceof Long) {
                    long value = (Long)objectValue;
                    return value;
                }
                if (objectValue instanceof Integer) {
                    int value = (Integer)objectValue;
                    return value;
                }
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (MBeanException e) {
            e.printStackTrace();
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
        return 0.0;
    }
}

