/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public abstract class QueryHandler {
    public abstract void handleQuery(Request var1, Response var2) throws IOException, ServletException;

    protected abstract void configureXStream(XStream var1);

    protected void writeXMLResponse(Request req, Response resp, Object result) throws IOException {
        this.writeXMLResponse(req, resp, result, "xml");
    }

    protected void writeXMLResponse(Request req, Response resp, Object result, String format) throws IOException {
        boolean formatAsJSON = false;
        if (format == null) {
            format = req.getParameter("format");
        }
        if (format != null && format.equals("json")) {
            formatAsJSON = true;
        }
        PrintWriter out = resp.getWriter();
        XStream xstream = null;
        if (formatAsJSON) {
            xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
        } else {
            xstream = new XStream();
            resp.setContentType("application/xml");
            resp.setCharacterEncoding("UTF-8");
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        this.configureXStream(xstream);
        xstream.toXML(result, (Writer)out);
    }
}

