/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin;

import com.staxnet.appserver.IAppServerConfiguration;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import javax.servlet.ServletException;
import net.stax.appserver.admin.AppStatsQuery;
import net.stax.appserver.admin.QueryHandler;
import net.stax.appserver.admin.StatusResult;
import net.stax.appserver.admin.ThreadsQuery;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class StaxApplicationQueryValve
extends ValveBase {
    private Map<String, QueryHandler> handlers = new HashMap<String, QueryHandler>();
    private StatusHandler statusHandler = new StatusHandler();

    public StaxApplicationQueryValve(IAppServerConfiguration config, int serverPort, Timer timer) throws ServletException {
        this.handlers.put("/_stax/status", this.statusHandler);
        this.handlers.put("/_stax/stats", new AppStatsQuery(serverPort, timer));
        this.handlers.put("/_stax/threads", new ThreadsQuery());
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (request.getRequestURI().startsWith("/_stax")) {
            try {
                this.handleStaxQuery(request, response);
            }
            catch (Exception e) {
                response.sendError(500, "Internal error");
            }
        } else {
            Valve nextValve = this.getNext();
            if (nextValve != null) {
                nextValve.invoke(request, response);
            }
        }
    }

    private void handleStaxQuery(Request request, Response response) throws ServletException, IOException {
        QueryHandler handler = this.handlers.get(request.getRequestURI());
        if (handler != null) {
            handler.handleQuery(request, response);
        } else {
            response.sendError(404, "Not found");
        }
    }

    class StatusHandler
    extends QueryHandler {
        StatusHandler() {
        }

        @Override
        public void handleQuery(Request request, Response response) throws IOException, ServletException {
            StatusResult result = new StatusResult("active");
            this.writeXMLResponse(request, response, result);
        }

        @Override
        protected void configureXStream(XStream xstream) {
            xstream.processAnnotations(StatusResult.class);
        }
    }
}

