/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.servlet.ServletException;
import net.stax.appserver.admin.QueryHandler;
import net.stax.appserver.admin.StackData;
import net.stax.appserver.admin.ThreadData;
import net.stax.appserver.admin.ThreadsResult;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public class ThreadsQuery
extends QueryHandler {
    @Override
    public void handleQuery(Request request, Response response) throws IOException, ServletException {
        ThreadsResult result = new ThreadsResult();
        this.collectThreadInfo(result);
        this.writeXMLResponse(request, response, result);
    }

    @Override
    protected void configureXStream(XStream xstream) {
        xstream.processAnnotations(ThreadsResult.class);
    }

    private void collectThreadInfo(ThreadsResult threadsResult) {
        long[] threadIds;
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        for (long threadId : threadIds = tb.getAllThreadIds()) {
            ThreadInfo info = tb.getThreadInfo(threadId, Integer.MAX_VALUE);
            ThreadData threadData = new ThreadData(info.getThreadName(), info.getThreadState().toString());
            for (StackTraceElement stackElement : info.getStackTrace()) {
                threadData.addStack(new StackData(stackElement.getClassName(), stackElement.getMethodName(), stackElement.getFileName(), stackElement.getLineNumber()));
            }
            threadsResult.add(threadData);
        }
    }
}

