/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin.jmx;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.management.MalformedObjectNameException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.stax.appserver.admin.jmx.MBeanHandler;
import net.stax.appserver.admin.jmx.MBeanInfoHandler;
import net.stax.appserver.admin.jmx.MBeanInvokeHandler;
import net.stax.appserver.admin.jmx.MBeansHandler;
import net.stax.appserver.admin.jmx.NotFoundException;
import net.stax.appserver.admin.jmx.RestHandler;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class JMXValve
extends ValveBase {
    private List<RestHandler> handlers = new ArrayList<RestHandler>();
    private String authToken;

    public JMXValve(String authToken) {
        this.authToken = authToken;
        this.handlers.add(new MBeansHandler());
        this.handlers.add(new MBeanInfoHandler());
        this.handlers.add(new MBeanInvokeHandler());
        this.handlers.add(new MBeanHandler());
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (request.getRequestURI().startsWith("/_stax/jmx")) {
            this.handleJMXRequest(request, response);
        } else {
            Valve nextValve = this.getNext();
            if (nextValve != null) {
                nextValve.invoke(request, response);
            }
        }
    }

    private void handleJMXRequest(Request request, Response response) throws IOException, ServletException {
        try {
            this.verifyAuthToken(request);
            String method = request.getMethod();
            String path = request.getRequestURI();
            path = path.substring("/_stax/jmx".length());
            request.setServletPath("/_stax/jmx");
            request.setPathInfo(path);
            String decodedPath = new URI(path).getPath();
            for (RestHandler handler : this.handlers) {
                Matcher matcher = handler.getPattern().matcher(decodedPath);
                if (!matcher.matches()) continue;
                try {
                    if (method.equals("GET")) {
                        handler.doGet(matcher, (HttpServletRequest)request, (HttpServletResponse)response);
                    } else if (method.equals("POST")) {
                        handler.doPost(matcher, (HttpServletRequest)request, (HttpServletResponse)response);
                    } else {
                        response.sendError(501);
                    }
                    return;
                }
                catch (NotFoundException e) {
                    response.sendError(404);
                }
                catch (MalformedObjectNameException e) {
                    response.sendError(404);
                }
                catch (Exception e) {
                    response.sendError(500);
                    e.printStackTrace();
                }
            }
            response.sendError(404);
        }
        catch (AuthenticationFailedException e) {
            response.sendError(401);
        }
        catch (URISyntaxException e) {
            response.sendError(400);
        }
    }

    private void verifyAuthToken(Request request) throws AuthenticationFailedException {
        if (this.authToken != null) {
            String auth = request.getParameter("authtoken");
            if (auth == null) {
                auth = request.getHeader("x-stax-auth");
            }
            if (auth == null || !auth.equals(this.authToken)) {
                throw new AuthenticationFailedException();
            }
        }
    }

    class AuthenticationFailedException
    extends Exception {
        AuthenticationFailedException() {
        }
    }
}

