/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin.jmx;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.servlet.http.HttpServletRequest;
import net.stax.appserver.admin.jmx.IJSONSerializable;
import net.stax.appserver.admin.jmx.JSONObjectFactory;
import net.stax.appserver.admin.jmx.Link;
import net.stax.appserver.admin.jmx.LinkGenerator;
import net.stax.appserver.admin.jmx.MBeanAttrs;
import net.stax.appserver.admin.jmx.MBeanInfoResource;
import net.stax.appserver.admin.jmx.MBeanName;
import net.stax.appserver.admin.jmx.MBeanParam;
import net.stax.appserver.admin.jmx.MBeanParams;
import net.stax.appserver.json.JSONArray;
import net.stax.appserver.json.JSONException;
import net.stax.appserver.json.JSONObject;
import net.stax.appserver.json.JSONTokener;

class JSONSerializer {
    JSONSerializer() {
    }

    public static MBeanAttrs attrsFromReader(String mbeanName, Reader reader) throws JSONException {
        JSONTokener tokener = new JSONTokener(reader);
        JSONObject obj = new JSONObject(tokener);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (String name : JSONObject.getNames(obj)) {
            attrs.put(name, obj.get(name));
        }
        return new MBeanAttrs(mbeanName, attrs);
    }

    public static MBeanParams paramsFromReader(String mbeanName, Reader reader) throws Exception {
        JSONTokener tokener = new JSONTokener(reader);
        JSONObject obj = new JSONObject(tokener);
        ArrayList<MBeanParam> params = new ArrayList<MBeanParam>();
        if (obj.has("params")) {
            JSONArray jsonParams = obj.getJSONArray("params");
            for (int i = 0; i < jsonParams.length(); ++i) {
                String value;
                JSONObject jsonParam = jsonParams.getJSONObject(i);
                String name = jsonParam.has("name") ? jsonParam.getString("name") : null;
                String string = value = jsonParam.has("value") ? jsonParam.getString("value") : null;
                if (!jsonParam.has("signature")) {
                    throw new IllegalArgumentException("Parameter is missing required key: signature");
                }
                String signature = jsonParam.getString("signature");
                MBeanParam param = new MBeanParam(name, value, signature);
                params.add(param);
            }
        }
        return new MBeanParams(params);
    }

    public static JSONObject toJSON(Collection<MBeanName> resources, final HttpServletRequest request) throws JSONException {
        JSONObject object = new JSONObject();
        JSONSerializer.setObject(object, "mbeans", resources, new JSONObjectFactory<MBeanName>(){

            @Override
            public JSONObject create(MBeanName mbean) throws JSONException {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", mbean.getName());
                Collection<Link> links = LinkGenerator.createMBeanLinks(mbean.getName(), request);
                JSONSerializer.setObject(jsonObject, "links", links, new JSONObjectFactory<Link>(){

                    @Override
                    public JSONObject create(Link link) throws JSONException {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("href", link.getUrl());
                        jsonObject.put("rel", link.getRel());
                        return jsonObject;
                    }
                });
                return jsonObject;
            }
        });
        return object;
    }

    public static JSONObject toJSON(MBeanAttrs attrs) throws JSONException {
        JSONObject object = new JSONObject();
        for (Map.Entry<String, Object> entry : attrs.getAttributes().entrySet()) {
            Object value = entry.getValue();
            object.put(entry.getKey(), JSONSerializer.toJSONValue(value));
        }
        return object;
    }

    private static Object toJSONValue(Object value) throws JSONException {
        return JSONSerializer.toJSONValue(value, new ArrayList<Object>(), 1, 3);
    }

    private static Object toJSONValue(Object value, List<Object> seenValues, int depth, int maxDepth) throws JSONException {
        if (value instanceof Boolean || value instanceof Double || value instanceof Integer || value instanceof Long || value instanceof String || value == null) {
            return value;
        }
        if (value instanceof IJSONSerializable) {
            IJSONSerializable ser = (IJSONSerializable)value;
            return ser.toJSON();
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            return new JSONArray(array);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < array.length; ++i) {
                try {
                    Object jsonValue = JSONSerializer.maybeToJSONValue(array[i], seenValues, depth, maxDepth);
                    jsonArray.put(i, jsonValue);
                    continue;
                }
                catch (JSONValueAbortException e) {
                    continue;
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            return jsonArray;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            BeanInfo bi = Introspector.getBeanInfo(value.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                try {
                    String declaringClass;
                    Method reader = pd.getReadMethod();
                    if (reader == null || (declaringClass = reader.getDeclaringClass().getName()).startsWith("java") || declaringClass.startsWith("javax")) continue;
                    Object propertyValue = reader.invoke(value, new Object[0]);
                    Object jsonValue = JSONSerializer.maybeToJSONValue(propertyValue, seenValues, depth, maxDepth);
                    jsonObject.put(pd.getName(), jsonValue);
                }
                catch (JSONValueAbortException e) {
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object maybeToJSONValue(Object value, List<Object> seenValues, int depth, int maxDepth) throws JSONException, JSONValueAbortException {
        boolean seenValue = seenValues.contains(value);
        int nextDepth = depth + 1;
        if (!seenValue && nextDepth <= maxDepth) {
            seenValues.add(value);
            try {
                Object object = JSONSerializer.toJSONValue(value, seenValues, nextDepth, maxDepth);
                return object;
            }
            finally {
                seenValues.remove(value);
            }
        }
        throw new JSONValueAbortException();
    }

    public static JSONObject toJSON(final MBeanInfoResource info, final HttpServletRequest request) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        JSONSerializer.setObject(jsonObject, "attributes", info.getAttributes(), new JSONObjectFactory<MBeanAttributeInfo>(){

            @Override
            public JSONObject create(MBeanAttributeInfo attr) throws JSONException {
                JSONObject attrObject = new JSONObject();
                attrObject.put("name", attr.getName());
                attrObject.put("description", attr.getDescription());
                attrObject.put("readable", attr.isReadable());
                attrObject.put("writable", attr.isWritable());
                attrObject.put("type", attr.getType());
                return attrObject;
            }
        });
        Collection<MBeanOperationInfo> operations = info.getOperations();
        if (operations != null) {
            JSONSerializer.setObject(jsonObject, "operations", operations, new JSONObjectFactory<MBeanOperationInfo>(){

                @Override
                public JSONObject create(MBeanOperationInfo op) throws JSONException {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("name", op.getName());
                    jsonObject.put("description", op.getDescription());
                    jsonObject.put("returns", op.getReturnType());
                    Link link = LinkGenerator.createMBeanInvoke(info.getName(), op.getName(), request);
                    JSONObject linkObject = new JSONObject();
                    linkObject.put("href", link.getUrl());
                    linkObject.put("rel", link.getRel());
                    jsonObject.put("link", linkObject);
                    List<MBeanParameterInfo> parameterInfo = Arrays.asList(op.getSignature());
                    JSONSerializer.setObject(jsonObject, "parameters", parameterInfo, new JSONObjectFactory<MBeanParameterInfo>(){

                        @Override
                        public JSONObject create(MBeanParameterInfo param) throws JSONException {
                            JSONObject paramObject = new JSONObject();
                            paramObject.put("name", param.getName());
                            paramObject.put("type", param.getType());
                            paramObject.put("description", param.getDescription());
                            return paramObject;
                        }
                    });
                    return jsonObject;
                }
            });
        }
        return jsonObject;
    }

    private static JSONObject toJSON(String rootName, Collection resources, JSONObjectFactory objectFactory) throws JSONException {
        JSONObject json = new JSONObject();
        return JSONSerializer.setObject(json, rootName, resources, objectFactory);
    }

    private static JSONObject setObject(JSONObject json, String name, Collection resources, JSONObjectFactory objectFactory) throws JSONException {
        JSONArray array = JSONSerializer.create(resources, objectFactory);
        json.put(name, array);
        return json;
    }

    private static JSONArray create(Collection collection, JSONObjectFactory factory) throws JSONException {
        JSONArray array = new JSONArray();
        Iterator it = collection.iterator();
        int i = 0;
        while (it.hasNext()) {
            array.put(i, factory.create(it.next()));
            ++i;
        }
        return array;
    }

    static class JSONValueAbortException
    extends Exception {
        JSONValueAbortException() {
        }
    }
}

