/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin.jmx;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import net.stax.appserver.admin.jmx.Link;

class LinkGenerator {
    LinkGenerator() {
    }

    public static Collection<Link> createMBeanLinks(String mbeanName, HttpServletRequest request) {
        ArrayList<Link> list = new ArrayList<Link>(4);
        list.add(LinkGenerator.createMBeanInfo(mbeanName, request));
        list.add(LinkGenerator.createMBeanAttributes(mbeanName, request));
        return list;
    }

    public static Link createMBeanInfo(String mbeanName, HttpServletRequest request) {
        String path = String.format("/mbean/%s:info", mbeanName);
        return new Link(LinkGenerator.toUrl(path, request), "info");
    }

    public static Link createMBeanAttributes(String mbeanName, HttpServletRequest request) {
        String path = String.format("/mbean/%s", mbeanName);
        return new Link(LinkGenerator.toUrl(path, request), "attributes");
    }

    public static Link createMBeanInvoke(String mbeanName, String operation, HttpServletRequest request) {
        String path = String.format("/mbean/%s:invoke/%s", mbeanName, operation);
        return new Link(LinkGenerator.toUrl(path, request), "invoke");
    }

    private static String toUrl(String path, HttpServletRequest request) {
        String scheme = request.getScheme();
        String host = request.getServerName();
        int port = request.getServerPort();
        String fullPath = request.getServletPath() + path;
        try {
            URI uri = new URI(scheme, null, host, port, fullPath, null, null);
            return uri.toURL().toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create URL for path: " + path);
        }
    }
}

